package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.ExtensibleMdibComponent
import org.somda.dsl.biceps.checkUnset
import java.math.BigInteger

@MdibDsl
public class PhysicalConnectorInfo : ExtensibleMdibComponent() {
    private val labelList: MutableList<LocalizedText> = mutableListOf()

    public var number: Int? = null
        private set

    public fun label(lang: String, value: () -> String = { "" }): LocalizedTextValue {
        return LocalizedTextValue(value(), lang).also {
            labelList.add(it)
        }
    }

    public fun labelRef(ref: String, version: BigInteger = BigInteger.ZERO): LocalizedTextReference {
        return LocalizedTextReference(ref, version).also {
            labelList.add(it)
        }
    }

    public val labels: List<LocalizedText> = labelList

    public fun number(init: Int): Int = init.also {
        checkUnset(number, "number") {
            number = it
        }
    }
}