package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public class Range {
    public var lower: Decimal? = null
        private set
    public var upper: Decimal? = null
        private set
    public var stepWidth: Decimal? = null
        private set
    public var relativeAccuracy: Decimal? = null
        private set
    public var absoluteAccuracy: Decimal? = null
        private set

    public fun lower(init: Decimal): Decimal = init.also {
        checkUnset(lower, "lower") {
            lower = init
        }
    }

    public fun upper(init: Decimal): Decimal = init.also {
        checkUnset(upper, "upper") {
            upper = init
        }
    }

    public fun stepWidth(init: Decimal): Decimal = init.also {
        checkUnset(stepWidth, "stepWidth") {
            stepWidth = init
        }
    }

    public fun relativeAccuracy(init: Decimal): Decimal = init.also {
        checkUnset(relativeAccuracy, "relativeAccuracy") {
            relativeAccuracy = init
        }
    }

    public fun absoluteAccuracy(init: Decimal): Decimal = init.also {
        checkUnset(absoluteAccuracy, "absoluteAccuracy") {
            absoluteAccuracy = init
        }
    }

}

public fun range(init: Range.() -> Unit = {}): Range = Range().apply(init)