package org.somda.dsl.biceps.base

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.Extension
import java.math.BigInteger

@MdibDsl
public class RemedyInfo {
    // todo extension: currently unused
    public var extension: Extension? = null
        private set

    private var descriptionList: MutableList<LocalizedText> = mutableListOf()

    public fun description(lang: String, value: () -> String = { "" }): LocalizedTextValue {
        return LocalizedTextValue(value(), lang).also {
            descriptionList.add(it)
        }
    }

    public fun descriptionRef(ref: String, version: BigInteger = BigInteger.ZERO): LocalizedTextReference {
        return LocalizedTextReference(ref, version).also {
            descriptionList.add(it)
        }
    }

    public val descriptions: List<LocalizedText> = descriptionList
}