package org.somda.dsl.biceps.base.tree

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.alert.AlertSystem
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.preProcess
import org.somda.dsl.biceps.sco.Sco
import org.somda.dsl.biceps.uniqueHandle

@MdibDsl
public abstract class ComplexDeviceComponent<T : Any>(
    handle: Handle, newState: () -> T
) : DeviceComponent<T>(handle, newState) {

    public var alertSystem: AlertSystem? = null
        private set

    public var sco: Sco? = null
        private set

    public fun alertSystem(handle: Handle = uniqueHandle(), init: AlertSystem.() -> Unit): AlertSystem {
        return AlertSystem(handle).preProcess {
            it.apply(init)
            check(alertSystem == null) {
                "Alert system set twice"
            }
            alertSystem = it
        }
    }

    public fun sco(handle: Handle = uniqueHandle(), init: Sco.() -> Unit): Sco {
        return Sco(handle).preProcess {
            it.apply(init)
            checkUnset(sco, "sco") {
                sco = it
            }
        }
    }
}