package org.somda.dsl.biceps.component

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.MdsOperatingMode
import org.somda.dsl.biceps.base.tree.ComplexDeviceComponent
import org.somda.dsl.biceps.base.tree.DeviceComponentState
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.context.SystemContext
import org.somda.dsl.biceps.preProcess
import org.somda.dsl.biceps.uniqueHandle
import java.util.*


@MdibDsl
public class MdsState : DeviceComponentState() {
    public var mdsOperatingMode: MdsOperatingMode? = null
        private set

    public var lang: Locale? = null
        private set

    public fun mdsOperatingMode(init: MdsOperatingMode): MdsOperatingMode = init.also {
        checkUnset(mdsOperatingMode, "mdsOperatingMode") {
            this.mdsOperatingMode = init
        }
    }

    public fun language(init: Locale): Locale = init.also {
        checkUnset(lang, "lang") {
            this.lang = it
        }
    }
}

@MdibDsl
public class Mds(
    handle: Handle
) : ComplexDeviceComponent<MdsState>(handle, { MdsState() }) {
    private val vmdList: MutableList<Vmd> = mutableListOf()

    private val batteryList: MutableList<Battery> = mutableListOf()

    public var systemContext: SystemContext? = null
        private set

    public var clock: Clock? = null
        private set

    public fun vmd(handle: Handle = uniqueHandle(), init: Vmd.() -> Unit = {}): Vmd {
        return Vmd(handle).preProcess {
            it.apply(init)
            vmdList.add(it)
        }
    }

    public val vmds: List<Vmd> = vmdList

    public fun battery(handle: Handle = uniqueHandle(), init: Battery.() -> Unit = {}): Battery {
        return Battery(handle).preProcess {
            it.apply(init)
            batteryList.add(it)
        }
    }

    public val batteries: List<Battery> = batteryList

    public fun systemContext(handle: Handle = uniqueHandle(), init: SystemContext.() -> Unit): SystemContext {
        return SystemContext(handle).preProcess {
            it.apply(init)
            checkUnset(systemContext, "systemContext") {
                systemContext = it
            }
        }
    }

    public fun clock(handle: Handle = uniqueHandle(), init: Clock.() -> Unit): Clock {
        return Clock(handle).preProcess {
            it.apply(init)
            checkUnset(clock, "clock") {
                clock = it
            }
        }
    }
}