package org.somda.dsl.biceps.context

import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.ContextAssociation
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.InstanceIdentifier
import org.somda.dsl.biceps.base.tree.DescriptorMultiState
import org.somda.dsl.biceps.base.tree.IdentifiableMdibComponent
import org.somda.dsl.biceps.checkUnset
import java.math.BigInteger
import java.time.Instant

public abstract class ContextState(
    handle: Handle,
) : IdentifiableMdibComponent(handle) {

    public var contextAssociation: ContextAssociation? = null
        private set

    public var bindingMdibVersion: BigInteger? = null
        private set

    public var unbindingMdibVersion: BigInteger? = null
        private set

    public var bindingStartTime: Instant? = null
        private set

    public var bindingEndTime: Instant? = null
        private set

    public var category: CodedValue? = null
        private set

    private val validatorList: MutableList<InstanceIdentifier> = mutableListOf()

    private val identificationList: MutableList<InstanceIdentifier> = mutableListOf()


    public fun contextAssociation(init: ContextAssociation): ContextAssociation = init.also {
        checkUnset(contextAssociation, "contextAssociation") {
            contextAssociation = it
        }
    }

    public fun bindingMdibVersion(init: BigInteger): BigInteger = init.also {
        checkUnset(bindingMdibVersion, "bindingMdibVersion") {
            bindingMdibVersion = it
        }
    }

    public fun bindingMdibVersion(init: Int): Int = init.also {
        checkUnset(bindingMdibVersion, "bindingMdibVersion") {
            bindingMdibVersion = it.toBigInteger()
        }
    }

    public fun bindingMdibVersion(init: Long): Long = init.also {
        checkUnset(bindingMdibVersion, "bindingMdibVersion") {
            bindingMdibVersion = it.toBigInteger()
        }
    }

    public fun unbindingMdibVersion(init: BigInteger): BigInteger = init.also {
        checkUnset(unbindingMdibVersion, "unbindingMdibVersion") {
            unbindingMdibVersion = it
        }
    }

    public fun unbindingMdibVersion(init: Int): Int = init.also {
        checkUnset(unbindingMdibVersion, "unbindingMdibVersion") {
            unbindingMdibVersion = it.toBigInteger()
        }
    }

    public fun unbindingMdibVersion(init: Long): Long = init.also {
        checkUnset(unbindingMdibVersion, "unbindingMdibVersion") {
            unbindingMdibVersion = it.toBigInteger()
        }
    }

    public fun bindingStartTime(init: Instant): Instant = init.also {
        checkUnset(bindingStartTime, "bindingStartTime") {
            bindingStartTime = it
        }
    }

    public fun bindingEndTime(init: Instant): Instant = init.also {
        checkUnset(bindingEndTime, "bindingEndTime") {
            bindingEndTime = it
        }
    }

    public fun category(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue {
        return CodedValue(base).apply(init).also {
            checkUnset(category, "category") {
                category = it
            }
        }
    }

    public fun validator(init: InstanceIdentifier.() -> Unit): InstanceIdentifier {
        return InstanceIdentifier().apply(init).also {
            validatorList.add(it)
        }
    }

    public fun identification(init: InstanceIdentifier.() -> Unit): InstanceIdentifier {
        return InstanceIdentifier().apply(init).also {
            identificationList.add(it)
        }
    }

    public val validators: List<InstanceIdentifier> = validatorList

    public val identification: List<InstanceIdentifier> = identificationList

}



public sealed class Context<T : Any>(
    handle: Handle,
    newState: (stateHandle: Handle) -> T
) : DescriptorMultiState<T>(handle, newState)