package org.somda.dsl.biceps.context

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.tree.DeviceComponent
import org.somda.dsl.biceps.base.tree.DeviceComponentState
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.preProcess
import org.somda.dsl.biceps.uniqueHandle

public class SystemContextState : DeviceComponentState()

@MdibDsl
public class SystemContext(
    handle: Handle
) : DeviceComponent<SystemContextState>(handle, { SystemContextState() }) {
    public var patientContext: PatientContext? = null
        private set

    public var locationContext: LocationContext? = null
        private set

    private val ensembleContextList: MutableList<EnsembleContext> = mutableListOf()

    private val workflowContextList: MutableList<WorkflowContext> = mutableListOf()


    public fun patientContext(handle: Handle = uniqueHandle(), init: PatientContext.() -> Unit = {}): PatientContext {
        return PatientContext(handle).preProcess {
            it.apply(init)
            checkUnset(patientContext, "patientContext") {
                patientContext = it
            }
        }
    }

    public fun locationContext(
        handle: Handle = uniqueHandle(),
        init: LocationContext.() -> Unit = {}
    ): LocationContext {
        return LocationContext(handle).preProcess {
            it.apply(init)
            checkUnset(locationContext, "locationContext") {
                locationContext = it
            }
        }
    }

    public fun ensembleContext(
        handle: Handle = uniqueHandle(),
        init: EnsembleContext.() -> Unit = {}
    ): EnsembleContext {
        return EnsembleContext(handle).preProcess {
            it.apply(init)
            ensembleContextList.add(it)
        }
    }

    public fun workflowContext(
        handle: Handle = uniqueHandle(),
        init: WorkflowContext.() -> Unit = {}
    ): WorkflowContext {
        return WorkflowContext(handle).preProcess {
            it.apply(init)
            workflowContextList.add(it)
        }
    }

    public val ensembleContexts: List<EnsembleContext> = ensembleContextList

    public val workflowContexts: List<WorkflowContext> = workflowContextList

}