package org.somda.dsl.biceps.context

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.ClinicalInfo
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.InstanceIdentifier
import org.somda.dsl.biceps.base.LocationReference
import org.somda.dsl.biceps.base.OrderDetail
import org.somda.dsl.biceps.base.PersonReference
import org.somda.dsl.biceps.base.tree.ExtensibleMdibComponent
import org.somda.dsl.biceps.checkUnset

public class WorkflowContextState(
    handle: Handle
): ContextState(handle) {

    public var workflowDetail: WorkflowDetail? = null
        private set

    public fun workflowDetail(init: WorkflowDetail.() -> Unit) {
        WorkflowDetail().apply(init).also {
            checkUnset(workflowDetail, "workflowDetail") {
                workflowDetail = it
            }
        }
    }
}

@MdibDsl
public open class WorkflowDetail(): ExtensibleMdibComponent() {

    public var patient: PersonReference? = null
        private set

    public var assignedLocation: LocationReference? = null
        private set

    public var visitNumber: InstanceIdentifier? = null
        private set

    private val dangerCodeList: MutableList<CodedValue> = mutableListOf()

    private val relevantClinicalInfoList: MutableList<ClinicalInfo> = mutableListOf()

    public var requestedOrderDetail: RequestedOrderDetail? = null
        private set

    public var performedOrderDetail: PerformedOrderDetail? = null
        private set

    public fun patient(init: PersonReference.() -> Unit): PersonReference =
        PersonReference().apply(init).also {
            checkUnset(patient, "patient") {
                patient = it
            }
        }

    public fun assignedLocation(init: LocationReference.() -> Unit): LocationReference =
        LocationReference().apply(init).also {
            checkUnset(assignedLocation, "assignedLocation") {
                assignedLocation = it
            }
        }

    public fun visitNumber(init: InstanceIdentifier): InstanceIdentifier =
        init.also {
            checkUnset(init, "visitNumber") {
                visitNumber = it
            }
        }

    public fun dangerCode(base: CodedValue, init: CodedValue.() -> Unit): CodedValue =
        CodedValue(base).apply(init).also {
            dangerCodeList.add(it)
        }

    public fun relevantClinicalInfo(init: ClinicalInfo.() -> Unit) {
        ClinicalInfo().apply(init).also {
            relevantClinicalInfoList.add(it)
        }
    }

    public fun requestedOrderDetail(placerOrderNumber: InstanceIdentifier, init: RequestedOrderDetail.() -> Unit): RequestedOrderDetail =
        RequestedOrderDetail(placerOrderNumber).apply(init).also {
            checkUnset(requestedOrderDetail, "requestedOrderDetail") {
                requestedOrderDetail = it
            }
        }

    public fun performedOrderDetail(init: PerformedOrderDetail.() -> Unit) {
        PerformedOrderDetail().apply(init).also {
            checkUnset(performedOrderDetail, "performedOrderDetail") {
                performedOrderDetail = it
            }
        }
    }

    public fun dangerCode(): List<CodedValue> = dangerCodeList

    public fun relevantClinicalInfo(): List<ClinicalInfo> = relevantClinicalInfoList

    @MdibDsl
    public class RequestedOrderDetail(
        public val placerOrderNumber: InstanceIdentifier,
    ): OrderDetail() {

        public constructor(base: RequestedOrderDetail) : this(base.placerOrderNumber)

        public var referringPhysician: PersonReference? = null
            private set

        public var requestingPhysician: PersonReference? = null
            private set

        public fun referringPhysician(init: PersonReference.() -> Unit): PersonReference =
            PersonReference().apply(init).also {
                checkUnset(referringPhysician, "referringPhysician") {
                    referringPhysician = it
                }
            }

        public fun requestingPhysician(init: PersonReference.() -> Unit): PersonReference =
            PersonReference().apply(init).also {
                checkUnset(requestingPhysician, "requestingPhysician") {
                    requestingPhysician = it
                }
            }
    }

    @MdibDsl
    public class PerformedOrderDetail(): OrderDetail() {

        public var fillerOrderNumber: InstanceIdentifier? = null
            private set

        private val resultingClinicalInfoList = mutableListOf<ClinicalInfo>()

        public fun fillerOrderNumber(init: InstanceIdentifier.() -> Unit): InstanceIdentifier =
            InstanceIdentifier().apply(init).also {
                checkUnset(fillerOrderNumber, "fillerOrderNumber") {
                    fillerOrderNumber = it
                }
            }

        public fun resultingClinicalInfo(init: ClinicalInfo.() -> Unit): ClinicalInfo =
            ClinicalInfo().apply(init).also {
                resultingClinicalInfoList.add(it)
            }

        public fun resultingClinicalInfo(): List<ClinicalInfo> = resultingClinicalInfoList
    }
}

public class WorkflowContext(
    handle: Handle
) : Context<WorkflowContextState>(handle, { stateHandle: Handle -> WorkflowContextState(stateHandle) })