package org.somda.dsl.biceps.metric

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Decimal
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.InstanceIdentifier
import org.somda.dsl.biceps.base.Measurement
import org.somda.dsl.biceps.base.MetricAvailability
import org.somda.dsl.biceps.base.MetricCategory
import org.somda.dsl.biceps.base.MetricQuality
import org.somda.dsl.biceps.base.StringMetricValue
import org.somda.dsl.biceps.base.measurement
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public class EnumStringMetricState : MetricState() {
    public var metricValue: StringMetricValue? = null
        private set

    public fun metricValue(metricQuality: MetricQuality, init: StringMetricValue.() -> Unit): StringMetricValue {
        return StringMetricValue(metricQuality).apply(init).also {
            checkUnset(metricValue, "metricValue") {
                metricValue = it
            }
        }
    }
}

@MdibDsl
public class EnumStringMetric(
    handle: Handle,
    metricCategory: MetricCategory,
    metricAvailability: MetricAvailability,
    unit: CodedValue
) : Metric<EnumStringMetricState>(
    handle,
    unit,
    metricCategory,
    metricAvailability,
    { EnumStringMetricState() }
) {
    private val allowedValueList: MutableList<AllowedValue> = mutableListOf()

    public fun allowedValue(value: String, init: AllowedValue.() -> Unit = {}): AllowedValue {
        return AllowedValue(value).apply(init).also {
            allowedValueList.add(it)
        }
    }

    public val allowedValues: List<AllowedValue> = allowedValueList

    @MdibDsl
    public class AllowedValue(public val value: String) {
        public var type: CodedValue? = null
            private set

        public var identification: InstanceIdentifier? = null
            private set

        public var characteristic: Measurement? = null
            private set

        public fun type(base: CodedValue, init: CodedValue.() -> Unit = {}): CodedValue = base.also(init).also {
            checkUnset(this.type, "type") {
                this.type = it
            }
        }

        public fun identification(init: InstanceIdentifier): InstanceIdentifier = init.also {
            checkUnset(this.identification, "identification") {
                this.identification = it
            }
        }

        public fun characteristic(
            measuredValue: Decimal,
            measurementUnit: CodedValue,
            init: CodedValue.() -> Unit = {}
        ): Measurement = measurement(measuredValue, measurementUnit, init).also {
            checkUnset(characteristic, "characteristic") {
                characteristic = it
            }
        }

        public fun characteristic(
            measurement: Measurement
        ): Measurement = measurement.also {
            checkUnset(characteristic, "characteristic") {
                characteristic = it
            }
        }
    }
}