package org.somda.dsl.biceps.metric

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Decimal
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.MetricAvailability
import org.somda.dsl.biceps.base.MetricCategory
import org.somda.dsl.biceps.base.MetricQuality
import org.somda.dsl.biceps.base.NumericMetricValue
import org.somda.dsl.biceps.base.Range
import org.somda.dsl.biceps.checkUnset
import kotlin.time.Duration

@MdibDsl
public class NumericMetricState : MetricState() {
    public var metricValue: NumericMetricValue? = null
        private set

    private val physiologicalRangeList: MutableList<Range> = mutableListOf()

    public var activeAveragingPeriod: Duration? = null
        private set

    public fun metricValue(metricQuality: MetricQuality, init: NumericMetricValue.() -> Unit): NumericMetricValue {
        return NumericMetricValue(metricQuality).apply(init).also {
            checkUnset(metricValue, "metricValue") {
                metricValue = it
            }
        }
    }

    public fun physiologicalRange(init: Range.() -> Unit): Range = Range().apply(init).also {
        physiologicalRangeList.add(it)
    }

    public val physiologicalRanges: List<Range> = physiologicalRangeList

    public fun activeAveragingPeriod(init: Duration): Duration = init.also {
        checkUnset(activeAveragingPeriod, "activeAveragingPeriod") {
            activeAveragingPeriod = it
        }
    }
}

@MdibDsl
public class NumericMetric(
    handle: Handle,
    metricCategory: MetricCategory,
    metricAvailability: MetricAvailability,
    unit: CodedValue,
    public val resolution: Decimal
) : Metric<NumericMetricState>(
    handle,
    unit,
    metricCategory,
    metricAvailability,
    { NumericMetricState() }
) {
    private val technicalRangeList: MutableList<Range> = mutableListOf()

    // todo averagingPeriod: currently unused
    public var averagingPeriod: Duration? = null
        private set

    public fun technicalRange(init: Range.() -> Unit): Range = Range().apply(init).also {
        technicalRangeList.add(it)
    }

    public val technicalRanges: List<Range> = technicalRangeList

    public fun averagingPeriod(init: Duration): Duration = init.also {
        checkUnset(averagingPeriod, "averagingPeriod") {
            averagingPeriod = it
        }
    }
}