package org.somda.dsl.biceps.sco

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.base.OperatingMode
import org.somda.dsl.biceps.base.tree.DeviceComponent
import org.somda.dsl.biceps.base.tree.DeviceComponentState
import org.somda.dsl.biceps.checkUnset
import org.somda.dsl.biceps.preProcess
import org.somda.dsl.biceps.uniqueHandle

@MdibDsl
public class ScoState : DeviceComponentState() {
    private val invocationRequestedList: MutableList<HandleRef> = mutableListOf()

    private val invocationRequiredList: MutableList<HandleRef> = mutableListOf()

    private val operationGroupList: MutableList<OperationGroup> = mutableListOf()

    public fun invocationRequested(vararg init: HandleRef): List<HandleRef> = init.onEach {
        invocationRequestedList.add(it)
    }.toList()

    public fun invocationRequired(vararg init: HandleRef): List<HandleRef> = init.onEach {
        invocationRequiredList.add(it)
    }.toList()

    public fun operationGroup(init: OperationGroup.() -> Unit): OperationGroup = OperationGroup().apply(init).also {
        operationGroupList.add(it)
    }

    public val invocationRequestedHandles: List<HandleRef> = invocationRequestedList

    public val invocationRequiredHandles: List<HandleRef> = invocationRequiredList

    public val operationGroups: List<OperationGroup> = operationGroupList

    @MdibDsl
    public class OperationGroup {
        public var type: CodedValue? = null
            private set
        public var operatingMode: OperatingMode? = null
            private set
        private val operationList: MutableList<HandleRef> = mutableListOf()

        public fun type(init: CodedValue): CodedValue = init.also {
            checkUnset(type, "type") {
                type = it
            }
        }

        public fun operatingMode(init: OperatingMode): OperatingMode = init.also {
            checkUnset(operatingMode, "operatingMode") {
                operatingMode = it
            }
        }

        public fun operation(vararg init: HandleRef): List<HandleRef> = init.onEach {
            operationList.add(it)
        }.toList()

        public val operations: List<HandleRef> = operationList
    }
}

@MdibDsl
public class Sco(
    handle: Handle
) : DeviceComponent<ScoState>(handle, { ScoState() }) {
    private val operationList: MutableList<Operation<*>> = mutableListOf()

    public fun setStringOperation(
        handle: Handle = uniqueHandle(),
        operationTarget: HandleRef,
        init: SetStringOperation.() -> Unit = {}
    ): SetStringOperation {
        return SetStringOperation(handle, operationTarget).preProcess {
            it.apply(init)
            operationList.add(it)
        }
    }

    public fun setValueOperation(
        handle: Handle = uniqueHandle(),
        operationTarget: HandleRef,
        init: SetValueOperation.() -> Unit = {}
    ): SetValueOperation {
        return SetValueOperation(handle, operationTarget).preProcess {
            it.apply(init)
            operationList.add(it)
        }
    }

    public fun activateOperation(
        handle: Handle = uniqueHandle(),
        operationTarget: HandleRef,
        init: ActivateOperation.() -> Unit = {}
    ): ActivateOperation {
        return ActivateOperation(handle, operationTarget).preProcess {
            it.apply(init)
            operationList.add(it)
        }
    }

    public fun setAlertStateOperation(
        handle: Handle = uniqueHandle(),
        operationTarget: HandleRef,
        init: SetAlertStateOperation.() -> Unit = {}
    ): SetAlertStateOperation {
        return SetAlertStateOperation(handle, operationTarget).preProcess {
            it.apply(init)
            operationList.add(it)
        }
    }

    public fun setComponentStateOperation(
        handle: Handle = uniqueHandle(),
        operationTarget: HandleRef,
        init: SetComponentStateOperation.() -> Unit = {}
    ): SetComponentStateOperation {
        return SetComponentStateOperation(handle, operationTarget).preProcess {
            it.apply(init)
            operationList.add(it)
        }
    }

    public fun setContextStateOperation(
        handle: Handle = uniqueHandle(),
        operationTarget: HandleRef,
        init: SetContextStateOperation.() -> Unit = {}
    ): SetContextStateOperation {
        return SetContextStateOperation(handle, operationTarget).preProcess {
            it.apply(init)
            operationList.add(it)
        }
    }

    public fun setMetricStateOperation(
        handle: Handle = uniqueHandle(),
        operationTarget: HandleRef,
        init: SetMetricStateOperation.() -> Unit = {}
    ): SetMetricStateOperation {
        return SetMetricStateOperation(handle, operationTarget).preProcess {
            it.apply(init)
            operationList.add(it)
        }
    }

    public val operations: List<Operation<*>> = operationList
}