package org.somda.dsl.biceps.sco

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.checkUnset

@MdibDsl
public class SetStringOperationState : OperationState() {
    private val allowedValuesList: MutableList<String> = mutableListOf()

    public fun allowedValue(init: String): String = init.also {
        allowedValuesList.add(init)
    }

    public val allowedValues: List<String> = allowedValuesList
}

@MdibDsl
public class SetStringOperation(handle: Handle, operationTarget: HandleRef) :
    Operation<SetStringOperationState>(handle, operationTarget, { SetStringOperationState() }) {

    public var maxLength: Int? = null
        private set

    public fun maxLength(init: Int): Int = init.also {
        checkUnset(maxLength, "maxLength") {
            maxLength = it
        }
    }
}