package org.somda.dsl.biceps.sco

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.Handle
import org.somda.dsl.biceps.base.HandleRef
import org.somda.dsl.biceps.base.Range

@MdibDsl
public class SetValueOperationState : OperationState() {
    private val allowedRangeList: MutableList<Range> = mutableListOf()

    public fun allowedRange(init: Range.() -> Unit): Range = Range().apply(init).also {
        allowedRangeList.add(it)
    }

    public val allowedRanges: List<Range> = allowedRangeList
}

@MdibDsl
public class SetValueOperation(handle: Handle, operationTarget: HandleRef) :
    Operation<SetValueOperationState>(handle, operationTarget, { SetValueOperationState() })