package org.somda.dsl.mpkp

import org.somda.dsl.rendering.jaxb.ExtensionRenderer
import org.somda.dsl.rendering.jaxb.JaxbContext
import org.somda.dsl.rendering.jaxb.Namespace
import org.somda.dsl.rendering.jaxb.NamespacePrefix
import org.somda.dsl.rendering.jaxb.XmlSchemaPath
import org.somda.dsl.rendering.jaxb.mapping.base.mapMustUnderstand
import org.somda.sdc.mpkp.model.ObjectFactory


public object MpkpExtensionsRenderer : ExtensionRenderer {
    override val jaxbContextPath: JaxbContext = JaxbContext("org.somda.sdc.mpkp.model")
    override val xmlSchemaPath: XmlSchemaPath? = null

    override val namespaceMapping: Pair<NamespacePrefix, Namespace>
        get() = NamespacePrefix("mpkp") to Namespace("urn:oid:1.3.111.2.11073.10701.3.1.1")

    override fun render(dslModel: Any): Any? {
        return when (dslModel) {
            is DisplayPrecisionExtension -> mapDisplayPrecisionExtension(dslModel)
            is DisplayedByExtension -> mapDisplayedByExtension(dslModel)
            else -> null
        }
    }

    private fun mapDisplayPrecisionExtension(
        src: DisplayPrecisionExtension
    ): Any {
        return with(ObjectFactory()) {
            createDisplayPrecision(createDisplayPrecisionType().apply {
                stepWidth = src.stepWidth.value
                mapMustUnderstand(src) { isMustUnderstand = true }
            })
        }
    }

    private fun mapDisplayedByExtension(
        src: DisplayedByExtension
    ): Any {
        return with(ObjectFactory()) {
            createDisplayedBy(createDisplayedByType().apply {
                referencedMetric = src.referencedMetric.name
                mapMustUnderstand(src) { isMustUnderstand = true }
            })
        }
    }
}