package org.somda.dsl.rendering.jaxb

import org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper

internal object NamespacePrefixMapperConverter {
    fun convert(mappings: Map<Namespace, NamespacePrefix?>): NamespacePrefixMapper {
        val declaredNamespaces = mappings.keys.toTypedArray<Namespace>().map { it.value }.toTypedArray()

        return object : NamespacePrefixMapper() {
            override fun getPreDeclaredNamespaceUris(): Array<String> {
                return declaredNamespaces
            }

            override fun getPreferredPrefix(namespaceUri: String, suggestion: String?, requirePrefix: Boolean): String {
                return when (val prefferedPrefix = mappings[Namespace(namespaceUri)]) {
                    null -> suggestion ?: throw Exception("Unresolvable preferred prefix for namespace '$namespaceUri'")
                    else -> prefferedPrefix.value
                }
            }
        }
    }
}