package org.somda.dsl.rendering.jaxb

import org.somda.dsl.biceps.Mdib
import org.somda.sdc.biceps.model.message.GetMdibResponse
import java.io.File
import java.io.FileOutputStream
import java.io.OutputStream

internal val installedExtensions: MutableSet<ExtensionRenderer> = mutableSetOf()

public fun installExtensionRenderer(extensionRenderer: ExtensionRenderer) {
    installedExtensions.add(extensionRenderer)
}

public fun Mdib.render() {
    renderTo(File(""))
}

public fun Mdib.renderTo(directory: File) {
    require(directory.absoluteFile.isDirectory || directory.mkdirs()) {
        "Could not access or create directory '${directory.absolutePath}'"
    }

    FileOutputStream(File(directory.absoluteFile, "${this.name}.xml")).use {
        renderTo(it)
    }
}

public fun Mdib.renderTo(outputStream: OutputStream) {
    MdibRenderer(
        installedExtensions,
        this
    ).renderTo(outputStream)
}

public fun Mdib.renderToGetMdibResponse(): GetMdibResponse {
    return MdibRenderer(
        installedExtensions,
        this
    ).renderToGetMdibResponse()
}