package org.somda.dsl.rendering.jaxb.mapping

import org.somda.dsl.biceps.context.ContextState
import org.somda.dsl.biceps.context.EnsembleContext
import org.somda.dsl.biceps.context.LocationContext
import org.somda.dsl.biceps.context.PatientContext
import org.somda.dsl.biceps.context.WorkflowContext
import org.somda.dsl.biceps.context.WorkflowContextState
import org.somda.dsl.biceps.context.WorkflowDetail
import org.somda.dsl.biceps.metric.StringMetric
import org.somda.dsl.rendering.jaxb.mapping.base.mapClinicalInfo
import org.somda.dsl.rendering.jaxb.mapping.base.mapCodedValue
import org.somda.dsl.rendering.jaxb.mapping.base.mapInstanceIdentifier
import org.somda.dsl.rendering.jaxb.mapping.base.mapLocationDetail
import org.somda.dsl.rendering.jaxb.mapping.base.mapLocationReference
import org.somda.dsl.rendering.jaxb.mapping.base.mapOrderDetail
import org.somda.dsl.rendering.jaxb.mapping.base.mapPersonReference
import org.somda.dsl.rendering.jaxb.mapping.base.mapStringMetricValue
import org.somda.sdc.biceps.model.participant.AbstractState
import org.somda.sdc.biceps.model.participant.EnsembleContextDescriptor
import org.somda.sdc.biceps.model.participant.LocationContextDescriptor
import org.somda.sdc.biceps.model.participant.PatientContextDescriptor
import org.somda.sdc.biceps.model.participant.StringMetricState
import org.somda.sdc.biceps.model.participant.WorkflowContextDescriptor

internal class ContextMapping(private val mappedStates: MutableList<AbstractState>) {
    private val baseMapping = BaseMapping(mappedStates)

    fun mapLocationContext(src: LocationContext): LocationContextDescriptor =
        LocationContextDescriptor().apply {
            baseMapping.mapIntoAbstractDescriptor(src, this)
        }

    fun mapPatientContext(src: PatientContext): PatientContextDescriptor =
        PatientContextDescriptor().apply {
            baseMapping.mapIntoAbstractDescriptor(src, this)
        }

    fun mapEnsembleContext(src: EnsembleContext): EnsembleContextDescriptor =
        EnsembleContextDescriptor().apply {
            baseMapping.mapIntoAbstractDescriptor(src, this)
        }

    fun mapWorkflowContext(src: WorkflowContext): WorkflowContextDescriptor =
        WorkflowContextDescriptor().apply {
            baseMapping.mapIntoAbstractDescriptor(src, this)
            mappedStates.addAll(mapWorkflowContextStates(src))
        }


    private fun mapWorkflowContextStates(src: WorkflowContext): List<org.somda.sdc.biceps.model.participant.WorkflowContextState> =
        src.states.map { mapWorkflowContextState(src, it) }.toList()

    private fun mapWorkflowContextState(src: WorkflowContext, state: WorkflowContextState) = org.somda.sdc.biceps.model.participant.WorkflowContextState().apply {
        baseMapping.mapIntoAbstractContextState(
            state,
            src.handle.ref,
            src.version,
            this
        )

        state.workflowDetail?.let {
            this.workflowDetail = mapWorkflowDetail(it)
        }
    }

    private fun mapWorkflowDetail(src: WorkflowDetail) = org.somda.sdc.biceps.model.participant.WorkflowContextState.WorkflowDetail().apply {
        this.patient = mapPersonReference(src.patient)
        this.assignedLocation = mapLocationReference(src.assignedLocation)
        this.visitNumber = mapInstanceIdentifier(src.visitNumber)
        this.dangerCode = src.dangerCode().map { mapCodedValue(it) }
        this.relevantClinicalInfo = src.relevantClinicalInfo().map { mapClinicalInfo(it) }
        this.requestedOrderDetail = src.requestedOrderDetail?.let { mapRequestedOrderDetail(it) }
        this.performedOrderDetail = src.performedOrderDetail?.let { mapPerformedOrderDetail(it) }
    }

    private fun mapRequestedOrderDetail(src: WorkflowDetail.RequestedOrderDetail) = org.somda.sdc.biceps.model.participant.WorkflowContextState.WorkflowDetail.RequestedOrderDetail().apply {
        mapOrderDetail(src, this)
        this.referringPhysician = mapPersonReference(src.referringPhysician)
        this.requestingPhysician = mapPersonReference(src.requestingPhysician)
        this.placerOrderNumber = mapInstanceIdentifier(src.placerOrderNumber)
    }

    private fun mapPerformedOrderDetail(src: WorkflowDetail.PerformedOrderDetail) = org.somda.sdc.biceps.model.participant.WorkflowContextState.WorkflowDetail.PerformedOrderDetail().apply {
        mapOrderDetail(src, this)
        this.fillerOrderNumber = mapInstanceIdentifier(src.fillerOrderNumber)
        this.resultingClinicalInfo = src.resultingClinicalInfo().map { mapClinicalInfo(it) }
    }


}