package org.somda.dsl.rendering.jaxb.mapping.base

import org.somda.dsl.biceps.sco.Operation
import org.somda.sdc.biceps.model.participant.AbstractOperationDescriptor.AccessLevel

public fun mapAccessLevel(src: Operation.AccessLevel?): AccessLevel? {
    return src?.let {
        when (it) {
            Operation.AccessLevel.USER -> AccessLevel.USR
            Operation.AccessLevel.CLINICAL_SUPER_USER -> AccessLevel.CS_USR
            Operation.AccessLevel.RESPONSIBLE_ORGANIZATION -> AccessLevel.RO
            Operation.AccessLevel.SERVICE_PERSONNEL -> AccessLevel.SP
            Operation.AccessLevel.OTHER -> AccessLevel.OTH
        }
    }
}