package org.somda.dsl.rendering.jaxb.mapping.base

import org.somda.sdc.biceps.model.participant.ClinicalInfo

public fun mapClinicalInfo(src: org.somda.dsl.biceps.base.ClinicalInfo?): ClinicalInfo? {
    return src?.let {
        ClinicalInfo().apply {
            this.type = mapCodedValue(it.type)
            this.code = mapCodedValue(it.code)
            this.criticality = mapCriticality(it.criticality)
            this.description = it.description().map { text -> mapLocalizedText(text) }
            this.relatedMeasurement = it.relatedMeasurement().map { measurement -> mapRelatedMeasurement(measurement) }
        }
    }
}

public fun mapCriticality(src: org.somda.dsl.biceps.base.ClinicalInfo.Criticality?): ClinicalInfo.Criticality? {
    return src?.let {
        when (it) {
            org.somda.dsl.biceps.base.ClinicalInfo.Criticality.LOW -> ClinicalInfo.Criticality.LO
            org.somda.dsl.biceps.base.ClinicalInfo.Criticality.HIGH -> ClinicalInfo.Criticality.HI
        }
    }
}

public fun mapRelatedMeasurement(src: org.somda.dsl.biceps.base.ClinicalInfo.RelatedMeasurement?): ClinicalInfo.RelatedMeasurement? {
    return src?.let {
        ClinicalInfo.RelatedMeasurement().apply {
            this.validity = mapMeasurementValidity(it.validity)
            this.value = mapMeasurement(it.value)
            this.referenceRange = it.referenceRange().map { range -> mapReferenceRange(range) }
        }
    }
}

public fun mapReferenceRange(src: org.somda.dsl.biceps.base.ClinicalInfo.RelatedMeasurement.ReferenceRange?): ClinicalInfo.RelatedMeasurement.ReferenceRange? {
    return src?.let {
        ClinicalInfo.RelatedMeasurement.ReferenceRange().apply {
            this.range = mapRange(it.range)
            this.meaning = mapCodedValue(it.meaning)
        }
    }
}