package org.somda.dsl.rendering.jaxb.mapping.base

import org.somda.dsl.biceps.base.DEFAULT_CODING_SYSTEM
import org.somda.sdc.biceps.model.participant.CodedValue

public fun mapCodedValue(src: org.somda.dsl.biceps.base.CodedValue?): CodedValue? {
    return src?.let {
        CodedValue().apply {
            code = it.code
            codingSystem = if (it.codingSystem != DEFAULT_CODING_SYSTEM) it.codingSystem else null
            codingSystemVersion = it.codingSystemVersion
            translation.addAll(src.translations.map { translation ->
                CodedValue.Translation().apply {
                    this.code = translation.code
                    this.codingSystem = if (translation.codingSystem != DEFAULT_CODING_SYSTEM) {
                        translation.codingSystem
                    } else {
                        null
                    }
                    this.codingSystemVersion = translation.codingSystemVersion
                }
            })
            conceptDescription.addAll(it.conceptDescriptions.map { text -> mapLocalizedText(text) })
        }
    }
}