package org.somda.dsl.rendering.jaxb.mapping.base

import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.rendering.jaxb.installedExtensions
import org.somda.sdc.biceps.model.extension.ExtensionType


public fun mapExtensions(src: List<Extension>): List<Any> {
    return src.map { extension ->
        checkNotNull(installedExtensions.firstNotNullOfOrNull { renderer -> renderer.render(extension) }) {
            "No renderer found for extension '${extension.name}'"
        }
    }
}

public fun makeOptionalExtension(src: List<Extension>): ExtensionType? {
    return when (src.isEmpty()) {
        false -> ExtensionType().apply { this.any = mapExtensions(src) }
        true -> null
    }
}

public fun mapMustUnderstand(extension: Extension, setTrue: () -> Unit) {
    if (extension.isMustUnderstand()) {
        setTrue()
    }
}