package org.somda.dsl.rendering.jaxb.mapping.base

import org.somda.sdc.biceps.model.participant.OrderDetail

public fun mapOrderDetail(src: org.somda.dsl.biceps.base.OrderDetail?): OrderDetail? {
    return src?.let {
        OrderDetail().apply {
            mapOrderDetail(src, this)
        }
    }
}

public fun mapOrderDetail(src: org.somda.dsl.biceps.base.OrderDetail, dst: OrderDetail) {
    dst.start = src.start
    dst.end = src.end
    dst.performer = src.performer().map { mapPersonParticipation(it) }
    dst.service = src.service().map { mapCodedValue(it) }
    dst.imagingProcedure = src.imagingProcedure().map { mapImagingProcedure(it) }
}