package org.somda.dsl.sdpi

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.CodedValue
import org.somda.dsl.biceps.base.Decimal
import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.biceps.base.tree.Extensions
import java.math.BigInteger

@MdibDsl
public class MdcAttribute(public val type: CodedValue)

@MdibDsl
public class CodedStringAttribute(public val mdcAttribute: MdcAttribute, public val value: String)

@MdibDsl
public class CodedIntegerAttribute(public val mdcAttribute: MdcAttribute, public val value: BigInteger)

@MdibDsl
public class CodedDecimalAttribute(public val mdcAttribute: MdcAttribute, public val value: Decimal)

@MdibDsl
public class CodedAttributesExtension : Extension("CodedAttributes") {
    private val codedStringAttributeList: MutableList<CodedStringAttribute> = mutableListOf()

    private val codedIntegerAttributeList: MutableList<CodedIntegerAttribute> = mutableListOf()

    private val codedDecimalAttributeList: MutableList<CodedDecimalAttribute> = mutableListOf()

    public fun codedString(type: CodedValue, value: String): CodedStringAttribute {
        return CodedStringAttribute(MdcAttribute(type), value).also {
            codedStringAttributeList.add(it)
        }
    }

    public val codedStrings: List<CodedStringAttribute> = codedStringAttributeList

    public fun codedInteger(type: CodedValue, value: Int): CodedIntegerAttribute {
        return CodedIntegerAttribute(MdcAttribute(type), value.toBigInteger()).also {
            codedIntegerAttributeList.add(it)
        }
    }

    public val codedIntegers: List<CodedIntegerAttribute> = codedIntegerAttributeList

    public fun codedDecimal(type: CodedValue, value: Decimal): CodedDecimalAttribute {
        return CodedDecimalAttribute(MdcAttribute(type), value).also {
            codedDecimalAttributeList.add(it)
        }
    }

    public val codedDecimals: List<CodedDecimalAttribute> = codedDecimalAttributeList
}

public fun Extensions.codedAttributes(init: CodedAttributesExtension.() -> Unit = {}) {
    add(CodedAttributesExtension().apply(init))
}