package org.somda.dsl.sdpi

import org.somda.dsl.biceps.MdibDsl
import org.somda.dsl.biceps.base.tree.Extension
import org.somda.dsl.biceps.base.tree.Extensions

public enum class Gender {
    MALE,
    FEMALE,
    OTHER,
    UNKNOWN
}

@MdibDsl
public class GenderExtension(public val gender: Gender) : Extension("Gender")

public fun Extensions.gender(gender: Gender, init: GenderExtension.() -> Unit = {}) {
    add(GenderExtension(gender).apply(init))
}