/*
 * Decompiled with CFR 0.152.
 */
package org.somda.dsl.biceps.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import org.jetbrains.annotations.NotNull;
import org.somda.dsl.biceps.Mdib;
import org.somda.dsl.biceps.MdibValidator;
import org.somda.dsl.biceps.MdibValidatorKt;
import org.somda.dsl.biceps.base.Handle;
import org.somda.dsl.biceps.base.tree.ComponentTree;
import org.somda.dsl.biceps.base.tree.Descriptor;
import org.somda.dsl.biceps.base.tree.DescriptorMultiState;
import org.somda.dsl.biceps.base.tree.VersionedMdibComponent;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/somda/dsl/biceps/validator/HandleValidator;", "Lorg/somda/dsl/biceps/MdibValidator;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "handleSet", "", "Lorg/somda/dsl/biceps/base/Handle;", "Lorg/somda/dsl/biceps/validator/HandleSet;", "contains", "", "handle", "init", "", "visitPreInit", "component", "Lorg/somda/dsl/biceps/base/tree/VersionedMdibComponent;", "validateHandle", "checkCharacters", "checkUniqueHandle", "mdib-dsl"})
@SourceDebugExtension(value={"SMAP\nHandleValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandleValidator.kt\norg/somda/dsl/biceps/validator/HandleValidator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n434#2:65\n507#2,5:66\n11245#3:71\n11580#3,3:72\n1557#4:75\n1628#4,3:76\n1557#4:79\n1628#4,3:80\n*S KotlinDebug\n*F\n+ 1 HandleValidator.kt\norg/somda/dsl/biceps/validator/HandleValidator\n*L\n40#1:65\n40#1:66,5\n42#1:71\n42#1:72,3\n43#1:75\n43#1:76,3\n44#1:79\n44#1:80,3\n*E\n"})
public final class HandleValidator
implements MdibValidator {
    @NotNull
    public static final HandleValidator INSTANCE = new HandleValidator();
    @NotNull
    private static final String name = "HandleValidator";
    @NotNull
    private static final Set<Handle> handleSet = new LinkedHashSet();

    private HandleValidator() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    public final boolean contains(@NotNull Handle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        return handleSet.contains(handle);
    }

    @Override
    public void init() {
        handleSet.clear();
    }

    @Override
    public void visitPreInit(@NotNull VersionedMdibComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        VersionedMdibComponent versionedMdibComponent = component;
        if (versionedMdibComponent instanceof Descriptor) {
            this.validateHandle(((Descriptor)component).getHandle());
        } else if (versionedMdibComponent instanceof DescriptorMultiState) {
            this.validateHandle(((DescriptorMultiState)component).getHandle());
        }
    }

    private final void validateHandle(Handle handle) {
        this.checkCharacters(handle);
        this.checkUniqueHandle(handle);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCharacters(Handle handle) {
        Object object;
        Object $this$mapTo$iv$iv;
        char it;
        char[] $this$filterTo$iv$iv;
        String $this$filter$iv = handle.getName();
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Object destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(Intrinsics.compare((int)it, (int)33) < 0 || Intrinsics.compare((int)it, (int)126) > 0)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        Object $this$map$iv = cArray;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(((char[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv2 : $this$mapTo$iv$iv) {
            it = item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(HexExtensionsKt.toHexString((int)it, (HexFormat)HexFormat.Companion.getUpperCase()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it2;
            Object item$iv$iv = iterator.next();
            String item$iv$iv2 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string2 = it2.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object.add(string2);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            String it2 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add("U+" + it2);
        }
        List invalidChars = (List)destination$iv$iv;
        if (!((Collection)invalidChars).isEmpty()) {
            String links = CollectionsKt.joinToString$default((Iterable)invalidChars, (CharSequence)"\n", null, null, (int)0, null, HandleValidator::checkCharacters$lambda$4, (int)30, null);
            MdibValidatorKt.queueError(this, (Function0<String>)((Function0)() -> HandleValidator.checkCharacters$lambda$5(handle, invalidChars, links)));
        }
    }

    private final void checkUniqueHandle(Handle handle) {
        if (!(!handleSet.contains(handle))) {
            boolean bl = false;
            String string = "Found duplicated handle name '" + handle.getName() + "'";
            throw new IllegalStateException(string.toString());
        }
        handleSet.add(handle);
    }

    @Override
    public void validate(@NotNull Mdib mdib, @NotNull ComponentTree.Root componentTree) {
        MdibValidator.DefaultImpls.validate(this, mdib, componentTree);
    }

    @Override
    public void visitPostInit(@NotNull VersionedMdibComponent component) {
        MdibValidator.DefaultImpls.visitPostInit(this, component);
    }

    private static final CharSequence checkCharacters$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  https://www.compart.com/de/unicode/" + it;
    }

    private static final String checkCharacters$lambda$5(Handle $handle, List $invalidChars, String $links) {
        return "Handle '" + $handle.getName() + "' contains the following invalid characters: " + CollectionsKt.joinToString$default((Iterable)$invalidChars, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "\n\nSee also:\n" + $links + "\n";
    }
}

