/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.model.plugins;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import org.jvnet.jaxb.util.PropertyFieldAccessorFactory;
import org.jvnet.jaxb.xjc.outline.FieldAccessorEx;
import org.somda.sdc.biceps.model.plugins.PluginUtil;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class CustomEqualsPlugin
extends Plugin {
    static final String CLASS_NAME = "ExtensionType";
    static final String CUSTOM_IS_EQUAL_NODE_METHOD = "customIsEqualNode";
    static final String EQUALS_METHOD = "equals";
    static final String GET_CLASS_METHOD = "getClass";
    static final String GET_METHOD = "get";
    static final String IS_EMPTY_METHOD = "isEmpty";
    static final String SIZE_METHOD = "size";

    public String getOptionName() {
        return "XcustomExtensionTypeEquals";
    }

    public String getUsage() {
        return " -XcustomExtensionTypeEquals to generate a custom equals method that also considers unknown extensions.";
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (ClassOutline o : outline.getClasses()) {
            if (!o.getImplClass().name().equals(CLASS_NAME)) continue;
            JMethod method = o.implClass.method(1, Boolean.TYPE, EQUALS_METHOD);
            method.annotate(Override.class);
            JVar methodParameter = method.param(Object.class, "object");
            JBlock methodBody = method.body();
            JExpression _this = JExpr._this();
            JExpression methodParameterNullOrDifferentClass = methodParameter.eq(JExpr._null()).cor(_this.invoke(GET_CLASS_METHOD).ne((JExpression)methodParameter.invoke(GET_CLASS_METHOD)));
            methodBody._if(methodParameterNullOrDifferentClass)._then()._return(JExpr.FALSE);
            JExpression methodParameterIsThis = _this.eq((JExpression)methodParameter);
            methodBody._if(methodParameterIsThis)._then()._return(JExpr.TRUE);
            FieldOutline[] fields = o.getDeclaredFields();
            if (fields.length > 0) {
                JVar _that = methodBody.decl(8, (JType)o.getImplClass(), "that", (JExpression)JExpr.cast((JType)o.getImplClass(), (JExpression)methodParameter));
                for (FieldOutline fieldOutline : fields) {
                    JBlock block = methodBody.block();
                    String fieldName = fieldOutline.getPropertyInfo().getName(true);
                    FieldAccessorEx leftFieldAccessor = PropertyFieldAccessorFactory.INSTANCE.createFieldAccessor(fieldOutline, _this);
                    FieldAccessorEx rightFieldAccessor = PropertyFieldAccessorFactory.INSTANCE.createFieldAccessor(fieldOutline, (JExpression)_that);
                    JVar leftValue = block.decl(leftFieldAccessor.getType(), "left" + fieldName);
                    leftFieldAccessor.toRawValue(block, leftValue);
                    JVar rightValue = block.decl(rightFieldAccessor.getType(), "right" + fieldName);
                    rightFieldAccessor.toRawValue(block, rightValue);
                    JExpression leftNotNullNotEmptyExpression = leftValue.ne(JExpr._null()).cand(leftValue.invoke(IS_EMPTY_METHOD).not());
                    JExpression rightNotNullNotEmptyExpression = rightValue.ne(JExpr._null()).cand(rightValue.invoke(IS_EMPTY_METHOD).not());
                    JExpression notSameSizeExpression = leftValue.invoke(SIZE_METHOD).ne((JExpression)rightValue.invoke(SIZE_METHOD));
                    JConditional leftNotNullBlock = block._if(leftNotNullNotEmptyExpression);
                    JConditional leftNotNullRightNotNullExpression = leftNotNullBlock._then()._if(rightNotNullNotEmptyExpression);
                    leftNotNullRightNotNullExpression._then()._if(notSameSizeExpression)._then()._return(JExpr.FALSE);
                    JForLoop forLoop = leftNotNullRightNotNullExpression._then().block()._for();
                    JVar iVar = forLoop.init((JType)o.parent().getCodeModel().INT, "i", JExpr.lit((int)0));
                    forLoop.test(iVar.lt((JExpression)leftValue.invoke(SIZE_METHOD)));
                    forLoop.update(iVar.assignPlus(JExpr.lit((int)1)));
                    JExpression bothElementsAreElementExpression = leftValue.invoke(GET_METHOD).arg((JExpression)iVar)._instanceof((JType)o.parent().getCodeModel().ref(Element.class)).cand(rightValue.invoke(GET_METHOD).arg((JExpression)iVar)._instanceof((JType)o.parent().getCodeModel().ref(Element.class)));
                    JConditional forLoopBothElement = forLoop.body()._if(bothElementsAreElementExpression);
                    JVar leftElement = forLoopBothElement._then().decl(8, (JType)o.parent().getCodeModel().ref(Element.class), "leftElement", (JExpression)JExpr.cast((JType)o.parent().getCodeModel().ref(Element.class), (JExpression)leftValue.invoke(GET_METHOD).arg((JExpression)iVar)));
                    JVar rightElement = forLoopBothElement._then().decl(8, (JType)o.parent().getCodeModel().ref(Element.class), "rightElement", (JExpression)JExpr.cast((JType)o.parent().getCodeModel().ref(Element.class), (JExpression)rightValue.invoke(GET_METHOD).arg((JExpression)iVar)));
                    forLoopBothElement._then()._if(o.parent().getCodeModel().ref(PluginUtil.class).staticInvoke(CUSTOM_IS_EQUAL_NODE_METHOD).arg((JExpression)leftElement).arg((JExpression)rightElement).not())._then()._return(JExpr.FALSE);
                    forLoopBothElement._else()._if(leftValue.invoke(GET_METHOD).arg((JExpression)iVar).invoke(EQUALS_METHOD).arg((JExpression)rightValue.invoke(GET_METHOD).arg((JExpression)iVar)).not())._then()._return(JExpr.FALSE);
                    leftNotNullRightNotNullExpression._else()._return(JExpr.FALSE);
                    leftNotNullBlock._else()._if(rightNotNullNotEmptyExpression)._then()._return(JExpr.FALSE);
                }
            }
            methodBody._return(JExpr.TRUE);
        }
        return true;
    }
}

