/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractState;

public class MdibDescriptionModification {
    private final Type modificationType;
    private final AbstractDescriptor descriptor;
    private final List<AbstractState> states;
    private final String parentHandle;

    public MdibDescriptionModification(Type modificationType, AbstractDescriptor descriptor, @Nullable List<AbstractState> states, @Nullable String parentHandle) {
        this.modificationType = modificationType;
        this.descriptor = descriptor;
        this.states = states == null ? Collections.emptyList() : states;
        this.parentHandle = parentHandle;
    }

    public MdibDescriptionModification(Type modificationType, AbstractDescriptor descriptor, @Nullable List<AbstractState> states) {
        this(modificationType, descriptor, states, null);
    }

    public Type getModificationType() {
        return this.modificationType;
    }

    public AbstractDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getHandle() {
        return this.descriptor.getHandle();
    }

    public List<AbstractState> getStates() {
        return this.states;
    }

    public Optional<String> getParentHandle() {
        return Optional.ofNullable(this.parentHandle);
    }

    public static enum Type {
        INSERT,
        UPDATE,
        DELETE;

    }
}

