/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.provider.preprocessing.HandleDuplicatedException;

public class MdibDescriptionModifications {
    private static final Logger LOG = LoggerFactory.getLogger(MdibDescriptionModifications.class);
    private List<MdibDescriptionModification> modifications = new ArrayList<MdibDescriptionModification>();
    private Set<String> insertedHandles = new HashSet<String>();
    private Set<String> updatedHandles = new HashSet<String>();
    private Set<String> deletedHandles = new HashSet<String>();

    private MdibDescriptionModifications() {
    }

    public static MdibDescriptionModifications create() {
        return new MdibDescriptionModifications();
    }

    public MdibDescriptionModifications add(MdibDescriptionModification.Type modType, Entry entry) {
        return this.add(modType, entry.getDescriptor(), entry.getState(), entry.getParentHandle());
    }

    public MdibDescriptionModifications add(MdibDescriptionModification.Type modType, MultiStateEntry entry) {
        return this.add(modType, entry.getDescriptor(), entry.getStates(), entry.getParentHandle());
    }

    public MdibDescriptionModifications add(MdibDescriptionModification.Type modType, AbstractDescriptor descriptor, @Nullable String parentHandle) {
        return this.addMdibModification(modType, descriptor, null, parentHandle);
    }

    public MdibDescriptionModifications add(MdibDescriptionModification.Type modType, AbstractDescriptor descriptor) {
        return this.addMdibModification(modType, descriptor, null, null);
    }

    public MdibDescriptionModifications add(MdibDescriptionModification.Type modType, AbstractDescriptor descriptor, @Nullable AbstractState state) {
        return this.addMdibModification(modType, descriptor, Collections.singletonList(state));
    }

    public MdibDescriptionModifications add(MdibDescriptionModification.Type modType, AbstractDescriptor descriptor, @Nullable AbstractState state, @Nullable String parentHandle) {
        return this.addMdibModification(modType, descriptor, Collections.singletonList(state), parentHandle);
    }

    public MdibDescriptionModifications add(MdibDescriptionModification.Type modType, AbstractDescriptor descriptor, List<? extends AbstractMultiState> multiStates) {
        multiStates.forEach(state -> this.duplicateDetection(modType, state.getHandle()));
        return this.addMdibModification(modType, descriptor, multiStates);
    }

    public MdibDescriptionModifications add(MdibDescriptionModification.Type modType, AbstractDescriptor descriptor, List<? extends AbstractMultiState> multiStates, @Nullable String parentHandle) {
        multiStates.forEach(state -> this.duplicateDetection(modType, state.getHandle()));
        return this.addMdibModification(modType, descriptor, multiStates, parentHandle);
    }

    public MdibDescriptionModifications insert(Entry entry) {
        return this.add(MdibDescriptionModification.Type.INSERT, entry.getDescriptor(), entry.getState(), entry.getParentHandle());
    }

    public MdibDescriptionModifications insert(MultiStateEntry entry) {
        return this.add(MdibDescriptionModification.Type.INSERT, entry.getDescriptor(), entry.getStates(), entry.getParentHandle());
    }

    public MdibDescriptionModifications insert(AbstractDescriptor descriptor) {
        return this.add(MdibDescriptionModification.Type.INSERT, descriptor);
    }

    public MdibDescriptionModifications insert(AbstractDescriptor descriptor, @Nullable String parentHandle) {
        return this.add(MdibDescriptionModification.Type.INSERT, descriptor, parentHandle);
    }

    public MdibDescriptionModifications insert(AbstractDescriptor descriptor, AbstractState state) {
        return this.add(MdibDescriptionModification.Type.INSERT, descriptor, state);
    }

    public MdibDescriptionModifications insert(AbstractDescriptor descriptor, AbstractState state, @Nullable String parentHandle) {
        return this.add(MdibDescriptionModification.Type.INSERT, descriptor, state, parentHandle);
    }

    public MdibDescriptionModifications insert(AbstractDescriptor descriptor, List<? extends AbstractMultiState> multiStates) {
        return this.add(MdibDescriptionModification.Type.INSERT, descriptor, multiStates);
    }

    public MdibDescriptionModifications insert(AbstractDescriptor descriptor, List<? extends AbstractMultiState> multiStates, @Nullable String parentHandle) {
        return this.add(MdibDescriptionModification.Type.INSERT, descriptor, multiStates, parentHandle);
    }

    public MdibDescriptionModifications update(Entry entry) {
        return this.add(MdibDescriptionModification.Type.UPDATE, entry.getDescriptor(), entry.getState(), entry.getParentHandle());
    }

    public MdibDescriptionModifications update(MultiStateEntry entry) {
        return this.add(MdibDescriptionModification.Type.UPDATE, entry.getDescriptor(), entry.getStates(), entry.getParentHandle());
    }

    public MdibDescriptionModifications update(AbstractDescriptor descriptor) {
        return this.add(MdibDescriptionModification.Type.UPDATE, descriptor);
    }

    public MdibDescriptionModifications update(AbstractDescriptor descriptor, AbstractState state) {
        return this.add(MdibDescriptionModification.Type.UPDATE, descriptor, state);
    }

    public MdibDescriptionModifications update(AbstractDescriptor descriptor, List<? extends AbstractMultiState> multiStates) {
        return this.add(MdibDescriptionModification.Type.UPDATE, descriptor, multiStates);
    }

    public MdibDescriptionModifications delete(Entry entry) {
        return this.add(MdibDescriptionModification.Type.DELETE, entry.getDescriptor());
    }

    public MdibDescriptionModifications delete(AbstractDescriptor descriptor) {
        return this.add(MdibDescriptionModification.Type.DELETE, descriptor);
    }

    public MdibDescriptionModifications delete(String handle) {
        AbstractDescriptor descr = new AbstractDescriptor();
        descr.setHandle(handle);
        return this.add(MdibDescriptionModification.Type.DELETE, descr);
    }

    public boolean isAddedAsInserted(String handle) {
        return this.insertedHandles.contains(handle);
    }

    public boolean isAddedAsUpdated(String handle) {
        return this.updatedHandles.contains(handle);
    }

    public boolean isAddedAsDeleted(String handle) {
        return this.deletedHandles.contains(handle);
    }

    public List<MdibDescriptionModification> getModifications() {
        return Collections.unmodifiableList(this.modifications);
    }

    public void clear() {
        this.modifications.clear();
        this.insertedHandles.clear();
        this.updatedHandles.clear();
        this.deletedHandles.clear();
    }

    private MdibDescriptionModifications addMdibModification(MdibDescriptionModification.Type modType, AbstractDescriptor descriptor, List<? extends AbstractState> states) {
        return this.addMdibModification(modType, descriptor, states, null);
    }

    private MdibDescriptionModifications addMdibModification(MdibDescriptionModification.Type modType, AbstractDescriptor descriptor, List<? extends AbstractState> states, @Nullable String parentHandle) {
        this.duplicateDetection(modType, descriptor.getHandle());
        this.modifications.add(new MdibDescriptionModification(modType, descriptor, states, parentHandle));
        return this;
    }

    private void duplicateDetection(MdibDescriptionModification.Type modType, String handle) {
        Set<String> handleSet;
        switch (modType) {
            case INSERT: {
                handleSet = this.insertedHandles;
                break;
            }
            case UPDATE: {
                handleSet = this.updatedHandles;
                break;
            }
            case DELETE: {
                handleSet = this.deletedHandles;
                break;
            }
            default: {
                LOG.warn("Found invalid description modification type: {}", (Object)modType);
                throw new RuntimeException("Found invalid description modification type");
            }
        }
        if (handleSet.contains(handle)) {
            throw new RuntimeException(new HandleDuplicatedException(String.format("Handle %s has already been inserted into description change set.", handle)));
        }
        handleSet.add(handle);
    }

    public static class MultiStateEntry {
        private AbstractDescriptor descriptor;
        private List<? extends AbstractMultiState> states;
        private String parentHandle;

        public MultiStateEntry(AbstractDescriptor descriptor, List<? extends AbstractMultiState> states, String parentHandle) {
            this.descriptor = descriptor;
            this.states = states;
            this.parentHandle = parentHandle;
        }

        public AbstractDescriptor getDescriptor() {
            return this.descriptor;
        }

        public List<? extends AbstractMultiState> getStates() {
            return this.states;
        }

        @Nullable
        private String getParentHandle() {
            return this.parentHandle;
        }
    }

    public static class Entry {
        private AbstractDescriptor descriptor;
        private AbstractState state;
        private String parentHandle;

        public Entry(AbstractDescriptor descriptor, AbstractState state) {
            this(descriptor, state, null);
        }

        public Entry(AbstractDescriptor descriptor, AbstractState state, @Nullable String parentHandle) {
            this.descriptor = descriptor;
            this.state = state;
            this.parentHandle = parentHandle;
        }

        public AbstractDescriptor getDescriptor() {
            return this.descriptor;
        }

        public AbstractState getState() {
            return this.state;
        }

        public String getParentHandle() {
            return this.parentHandle;
        }
    }
}

