/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.MdibTypeValidator;
import org.somda.sdc.biceps.common.access.CopyManager;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdibVersion;

public class MdibEntityImpl
implements MdibEntity {
    private final String parent;
    private final List<String> children;
    private final AbstractDescriptor descriptor;
    private final List<AbstractState> states;
    private final MdibVersion mdibVersion;
    private final CopyManager copyManager;
    private final Class<? extends AbstractState> stateClass;

    @AssistedInject
    MdibEntityImpl(@Assisted @Nullable String parent, @Assisted(value="children") List<String> children, @Assisted AbstractDescriptor descriptor, @Assisted(value="states") List<AbstractState> states, @Assisted MdibVersion mdibVersion, CopyManager copyManager, MdibTypeValidator typeValidator) {
        this.parent = parent;
        this.children = children;
        this.descriptor = descriptor;
        this.states = states;
        this.mdibVersion = mdibVersion;
        this.copyManager = copyManager;
        try {
            this.stateClass = typeValidator.resolveStateType(descriptor.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Unexpected descriptor class with no matching state class found: %s", descriptor.getClass()));
        }
    }

    @Override
    public MdibVersion getLastChanged() {
        return this.mdibVersion;
    }

    @Override
    public List<String> getChildren() {
        return this.children;
    }

    @Override
    public AbstractDescriptor getDescriptor() {
        return this.copyManager.processOutput(this.descriptor);
    }

    @Override
    public <T extends AbstractDescriptor> Optional<T> getDescriptor(Class<T> theClass) {
        return theClass.isAssignableFrom(this.descriptor.getClass()) ? Optional.of((AbstractDescriptor)theClass.cast(this.getDescriptor())) : Optional.empty();
    }

    @Override
    public String getHandle() {
        return this.descriptor.getHandle();
    }

    @Override
    public Optional<String> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public List<AbstractState> getStates() {
        return this.copyManager.processOutput(this.states);
    }

    @Override
    public <T extends AbstractState> List<T> getStates(Class<T> theClass) {
        if (!this.states.isEmpty() && theClass.isAssignableFrom(this.states.get(0).getClass())) {
            return this.copyManager.processOutput(this.states);
        }
        return new ArrayList();
    }

    @Override
    public <T extends AbstractState> Optional<T> getFirstState(Class<T> theClass) {
        if (!this.states.isEmpty() && theClass.isAssignableFrom(this.states.get(0).getClass())) {
            return Optional.of((AbstractState)theClass.cast(this.copyManager.processOutput(this.states.get(0))));
        }
        return Optional.empty();
    }

    @Override
    public MdibEntity.StateAlternative<List<AbstractMultiState>> doIfSingleState(Consumer<AbstractState> consumer) {
        if (!this.getStates().isEmpty() && !AbstractMultiState.class.isAssignableFrom(this.getStates().get(0).getClass())) {
            consumer.accept(this.getStates().get(0));
            return stateAlternativeConsumer -> {};
        }
        return stateAlternativeConsumer -> stateAlternativeConsumer.accept(this.getStates());
    }

    @Override
    public MdibEntity.StateAlternative<AbstractState> doIfMultiState(Consumer<List<AbstractMultiState>> consumer) {
        if (this.getStates().isEmpty()) {
            consumer.accept(Collections.emptyList());
            return stateAlternativeConsumer -> {};
        }
        if (AbstractMultiState.class.isAssignableFrom(this.getStates().get(0).getClass())) {
            consumer.accept(this.getStates());
            return stateAlternativeConsumer -> {};
        }
        return stateAlternativeConsumer -> stateAlternativeConsumer.accept(this.getStates().get(0));
    }

    @Override
    public Class<? extends AbstractDescriptor> getDescriptorClass() {
        return this.descriptor.getClass();
    }

    @Override
    public Class<? extends AbstractState> getStateClass() {
        return this.stateClass;
    }
}

