/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.somda.sdc.biceps.common.event.AlertStateModificationMessage;
import org.somda.sdc.biceps.common.event.ComponentStateModificationMessage;
import org.somda.sdc.biceps.common.event.ContextStateModificationMessage;
import org.somda.sdc.biceps.common.event.MetricStateModificationMessage;
import org.somda.sdc.biceps.common.event.OperationStateModificationMessage;
import org.somda.sdc.biceps.common.event.StateModificationMessage;
import org.somda.sdc.biceps.common.event.WaveformStateModificationMessage;
import org.somda.sdc.biceps.model.participant.AbstractAlertState;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractDeviceComponentState;
import org.somda.sdc.biceps.model.participant.AbstractMetricState;
import org.somda.sdc.biceps.model.participant.AbstractOperationState;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.RealTimeSampleArrayMetricState;

public class MdibStateModifications {
    private final Type changeType;
    private List<AbstractState> states;

    private MdibStateModifications(Type changeType) {
        this.changeType = changeType;
        this.states = new ArrayList<AbstractState>();
    }

    private MdibStateModifications(Type changeType, int initialCapacity) {
        this.changeType = changeType;
        this.states = new ArrayList<AbstractState>(initialCapacity);
    }

    public static MdibStateModifications create(Type changeType) {
        return new MdibStateModifications(changeType);
    }

    public static MdibStateModifications create(Type changeType, int initialCapacity) {
        return new MdibStateModifications(changeType, initialCapacity);
    }

    public MdibStateModifications add(AbstractState state) {
        if (!this.changeType.getChangeBaseClass().isAssignableFrom(state.getClass())) {
            throw new ClassCastException(String.format("Expected added state to be of type %s, but was %s.", this.changeType.getChangeBaseClass(), state.getClass()));
        }
        this.states.add(state);
        return this;
    }

    public <T extends AbstractState> MdibStateModifications addAll(Collection<T> states) {
        states.stream().forEach(state -> this.add((AbstractState)state));
        return this;
    }

    public List<AbstractState> getStates() {
        return this.states;
    }

    public Type getChangeType() {
        return this.changeType;
    }

    public void clear() {
        this.states.clear();
    }

    public static enum Type {
        ALERT(AbstractAlertState.class, AlertStateModificationMessage.class),
        COMPONENT(AbstractDeviceComponentState.class, ComponentStateModificationMessage.class),
        CONTEXT(AbstractContextState.class, ContextStateModificationMessage.class),
        METRIC(AbstractMetricState.class, MetricStateModificationMessage.class),
        OPERATION(AbstractOperationState.class, OperationStateModificationMessage.class),
        WAVEFORM(RealTimeSampleArrayMetricState.class, WaveformStateModificationMessage.class);

        private Class<? extends AbstractState> changeBaseClass;
        private Class<? extends StateModificationMessage<?>> eventMessageClass;

        private Type(Class<? extends AbstractState> changeBaseClass, Class<? extends StateModificationMessage<?>> eventMessageClass) {
            this.changeBaseClass = changeBaseClass;
            this.eventMessageClass = eventMessageClass;
        }

        Class<? extends AbstractState> getChangeBaseClass() {
            return this.changeBaseClass;
        }

        public Class<? extends StateModificationMessage<?>> getEventMessageClass() {
            return this.eventMessageClass;
        }
    }
}

