/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common;

import com.google.common.collect.HashMultimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.ActivateOperationDescriptor;
import org.somda.sdc.biceps.model.participant.AlertConditionDescriptor;
import org.somda.sdc.biceps.model.participant.AlertSignalDescriptor;
import org.somda.sdc.biceps.model.participant.AlertSystemDescriptor;
import org.somda.sdc.biceps.model.participant.BatteryDescriptor;
import org.somda.sdc.biceps.model.participant.ChannelDescriptor;
import org.somda.sdc.biceps.model.participant.ClockDescriptor;
import org.somda.sdc.biceps.model.participant.DistributionSampleArrayMetricDescriptor;
import org.somda.sdc.biceps.model.participant.EnsembleContextDescriptor;
import org.somda.sdc.biceps.model.participant.EnumStringMetricDescriptor;
import org.somda.sdc.biceps.model.participant.LimitAlertConditionDescriptor;
import org.somda.sdc.biceps.model.participant.LocationContextDescriptor;
import org.somda.sdc.biceps.model.participant.MdsDescriptor;
import org.somda.sdc.biceps.model.participant.MeansContextDescriptor;
import org.somda.sdc.biceps.model.participant.NumericMetricDescriptor;
import org.somda.sdc.biceps.model.participant.OperatorContextDescriptor;
import org.somda.sdc.biceps.model.participant.PatientContextDescriptor;
import org.somda.sdc.biceps.model.participant.RealTimeSampleArrayMetricDescriptor;
import org.somda.sdc.biceps.model.participant.ScoDescriptor;
import org.somda.sdc.biceps.model.participant.SetAlertStateOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetComponentStateOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetContextStateOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetMetricStateOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetStringOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetValueOperationDescriptor;
import org.somda.sdc.biceps.model.participant.StringMetricDescriptor;
import org.somda.sdc.biceps.model.participant.SystemContextDescriptor;
import org.somda.sdc.biceps.model.participant.VmdDescriptor;
import org.somda.sdc.biceps.model.participant.WorkflowContextDescriptor;

public class MdibTreeValidator {
    private final HashMultimap<Class<?>, Class<?>> allowedParents = HashMultimap.create();
    private final Set<Class<?>> oneChildEntities = new HashSet();

    @Inject
    MdibTreeValidator() {
        this.setupAllowedParents();
        this.setupChildCardinality();
    }

    public <T extends AbstractDescriptor> boolean isManyAllowed(T child) {
        return !this.oneChildEntities.contains(child.getClass());
    }

    public boolean isValidParent(AbstractDescriptor parent, AbstractDescriptor child) {
        return this.allowedParents.containsEntry(child.getClass(), parent.getClass());
    }

    public Set<Class<?>> allowedParents(AbstractDescriptor child) {
        return this.allowedParents.get(child.getClass());
    }

    private void setupAllowedParents() {
        this.allowedParents.put(VmdDescriptor.class, MdsDescriptor.class);
        this.allowedParents.put(ChannelDescriptor.class, VmdDescriptor.class);
        this.allowedParents.put(NumericMetricDescriptor.class, ChannelDescriptor.class);
        this.allowedParents.put(StringMetricDescriptor.class, ChannelDescriptor.class);
        this.allowedParents.put(EnumStringMetricDescriptor.class, ChannelDescriptor.class);
        this.allowedParents.put(RealTimeSampleArrayMetricDescriptor.class, ChannelDescriptor.class);
        this.allowedParents.put(DistributionSampleArrayMetricDescriptor.class, ChannelDescriptor.class);
        this.allowedParents.replaceValues(AlertSystemDescriptor.class, Arrays.asList(MdsDescriptor.class, VmdDescriptor.class));
        this.allowedParents.put(AlertConditionDescriptor.class, AlertSystemDescriptor.class);
        this.allowedParents.put(LimitAlertConditionDescriptor.class, AlertSystemDescriptor.class);
        this.allowedParents.put(AlertSignalDescriptor.class, AlertSystemDescriptor.class);
        this.allowedParents.replaceValues(ScoDescriptor.class, Arrays.asList(MdsDescriptor.class, VmdDescriptor.class));
        this.allowedParents.put(ActivateOperationDescriptor.class, ScoDescriptor.class);
        this.allowedParents.put(SetStringOperationDescriptor.class, ScoDescriptor.class);
        this.allowedParents.put(SetValueOperationDescriptor.class, ScoDescriptor.class);
        this.allowedParents.put(SetComponentStateOperationDescriptor.class, ScoDescriptor.class);
        this.allowedParents.put(SetMetricStateOperationDescriptor.class, ScoDescriptor.class);
        this.allowedParents.put(SetContextStateOperationDescriptor.class, ScoDescriptor.class);
        this.allowedParents.put(SetAlertStateOperationDescriptor.class, ScoDescriptor.class);
        this.allowedParents.put(ClockDescriptor.class, MdsDescriptor.class);
        this.allowedParents.put(BatteryDescriptor.class, MdsDescriptor.class);
        this.allowedParents.put(SystemContextDescriptor.class, MdsDescriptor.class);
        this.allowedParents.put(PatientContextDescriptor.class, SystemContextDescriptor.class);
        this.allowedParents.put(LocationContextDescriptor.class, SystemContextDescriptor.class);
        this.allowedParents.put(EnsembleContextDescriptor.class, SystemContextDescriptor.class);
        this.allowedParents.put(WorkflowContextDescriptor.class, SystemContextDescriptor.class);
        this.allowedParents.put(MeansContextDescriptor.class, SystemContextDescriptor.class);
        this.allowedParents.put(OperatorContextDescriptor.class, SystemContextDescriptor.class);
    }

    void setupChildCardinality() {
        this.oneChildEntities.add(AlertSystemDescriptor.class);
        this.oneChildEntities.add(SystemContextDescriptor.class);
        this.oneChildEntities.add(ScoDescriptor.class);
        this.oneChildEntities.add(PatientContextDescriptor.class);
        this.oneChildEntities.add(LocationContextDescriptor.class);
    }
}

