/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.somda.sdc.biceps.model.participant.AbstractContextDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;

public class MdibTypeValidator {
    private static final String ABSTRACT_PREFIX = "Abstract";
    private static final String DESCRIPTOR_SUFFIX = "Descriptor";
    private static final int DESCRIPTOR_SUFFIX_LENGTH = "Descriptor".length();
    private static final String STATE_SUFFIX = "State";
    private static final int STATE_SUFFIX_LENGTH = "State".length();

    @Inject
    MdibTypeValidator() {
    }

    public String resolveDescriptorBaseName(Class<? extends AbstractDescriptor> descrClass) {
        return descrClass.getSimpleName().substring(0, descrClass.getSimpleName().length() - DESCRIPTOR_SUFFIX_LENGTH);
    }

    public String resolveStateBaseName(Class<? extends AbstractState> stateClass) {
        return stateClass.getSimpleName().substring(0, stateClass.getSimpleName().length() - STATE_SUFFIX_LENGTH);
    }

    public boolean match(Class<? extends AbstractDescriptor> descrClass, Class<? extends AbstractState> stateClass) {
        if (descrClass.getSimpleName().startsWith(ABSTRACT_PREFIX) || stateClass.getSimpleName().startsWith(ABSTRACT_PREFIX)) {
            return false;
        }
        String name1 = this.resolveDescriptorBaseName(descrClass);
        String name2 = this.resolveStateBaseName(stateClass);
        return name1.equals(name2);
    }

    public <D extends AbstractDescriptor, S extends AbstractState> boolean match(D descriptor, List<S> states) {
        boolean singleStateOk = this.isSingleStateDescriptor(descriptor) && states.size() == 1;
        boolean multiStateOk = this.isMultiStateDescriptor(descriptor);
        boolean typesAndHandleRefsOk = states.stream().noneMatch(s -> !descriptor.getHandle().equals(s.getDescriptorHandle()) || !this.match((AbstractDescriptor)descriptor.getClass(), (AbstractState)s.getClass()));
        return typesAndHandleRefsOk && (singleStateOk || multiStateOk);
    }

    public <D extends AbstractDescriptor, S extends AbstractState> boolean match(D descriptor, S state) {
        return this.match(descriptor, (S)Collections.singletonList(state));
    }

    public <T extends AbstractDescriptor> boolean isSingleStateDescriptor(T descriptor) {
        return !this.isMultiStateDescriptor(descriptor);
    }

    public <T extends AbstractState> boolean isSingleState(T state) {
        return !this.isMultiState(state);
    }

    public <T extends AbstractDescriptor> boolean isMultiStateDescriptor(T descriptor) {
        return descriptor instanceof AbstractContextDescriptor;
    }

    public <T extends AbstractState> boolean isMultiState(T state) {
        return state instanceof AbstractMultiState;
    }

    public <T extends AbstractState> boolean isContextState(T state) {
        return state instanceof AbstractContextState;
    }

    public <T extends AbstractState> Optional<AbstractMultiState> toMultiState(T state) {
        if (this.isMultiState(state)) {
            return Optional.of((AbstractMultiState)state);
        }
        return Optional.empty();
    }

    public <T extends AbstractState> Optional<AbstractContextState> toContextState(T state) {
        if (this.isContextState(state)) {
            return Optional.of((AbstractContextState)state);
        }
        return Optional.empty();
    }

    public <T extends AbstractState, V extends AbstractDescriptor> Class<V> resolveDescriptorType(Class<T> stateClass) throws ClassNotFoundException {
        String baseName = stateClass.getCanonicalName().substring(0, stateClass.getCanonicalName().length() - STATE_SUFFIX_LENGTH);
        return Class.forName(baseName + DESCRIPTOR_SUFFIX);
    }

    public <T extends AbstractDescriptor, V extends AbstractState> Class<V> resolveStateType(Class<T> descriptorClass) throws ClassNotFoundException {
        String baseName = descriptorClass.getCanonicalName().substring(0, descriptorClass.getCanonicalName().length() - DESCRIPTOR_SUFFIX_LENGTH);
        return Class.forName(baseName + STATE_SUFFIX);
    }
}

