/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common.access;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.somda.sdc.common.util.ObjectUtil;

public class CopyManager {
    private final ObjectUtil objectUtil;
    private final Boolean copyInput;
    private final Boolean copyOutput;

    @Inject
    CopyManager(ObjectUtil objectUtil, @Named(value="Biceps.Common.CopyMdibInput") Boolean copyInput, @Named(value="Biceps.Common.CopyMdibInput") Boolean copyOutput) {
        this.objectUtil = objectUtil;
        this.copyInput = copyInput;
        this.copyOutput = copyOutput;
    }

    public <T> T processInput(T input) {
        return this.doDeepCopyIfConfigured(this.copyInput, input);
    }

    public <T> T processOutput(T output) {
        return this.doDeepCopyIfConfigured(this.copyOutput, output);
    }

    private <T> T doDeepCopyIfConfigured(boolean doCopy, T data) {
        if (doCopy) {
            return (T)this.objectUtil.deepCopy(data);
        }
        return data;
    }
}

