/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common.access;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.access.ReadTransaction;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdibVersion;

public class ReadTransactionImpl
implements ReadTransaction {
    private final Lock lock;
    private final MdibStorage mdibStorage;

    @AssistedInject
    public ReadTransactionImpl(@Assisted MdibStorage mdibStorage, @Assisted Lock lock) {
        this.lock = lock;
        this.lock.lock();
        this.mdibStorage = mdibStorage;
    }

    @Override
    public void close() {
        this.lock.unlock();
    }

    @Override
    public MdibVersion getMdibVersion() {
        return this.mdibStorage.getMdibVersion();
    }

    @Override
    public BigInteger getMdDescriptionVersion() {
        return this.mdibStorage.getMdDescriptionVersion();
    }

    @Override
    public BigInteger getMdStateVersion() {
        return this.mdibStorage.getMdStateVersion();
    }

    @Override
    public <T extends AbstractDescriptor> Optional<T> getDescriptor(String handle, Class<T> descrClass) {
        return this.mdibStorage.getDescriptor(handle, descrClass);
    }

    @Override
    public Optional<AbstractDescriptor> getDescriptor(String handle) {
        return this.getDescriptor(handle, AbstractDescriptor.class);
    }

    @Override
    public Optional<MdibEntity> getEntity(String handle) {
        return this.mdibStorage.getEntity(handle);
    }

    @Override
    public List<MdibEntity> getRootEntities() {
        return this.mdibStorage.getRootEntities();
    }

    @Override
    public Optional<AbstractState> getState(String handle) {
        return this.mdibStorage.getState(handle);
    }

    @Override
    public <T extends AbstractState> Optional<T> getState(String handle, Class<T> stateClass) {
        return this.mdibStorage.getState(handle, stateClass);
    }

    @Override
    public <T extends AbstractContextState> List<T> getContextStates(String descriptorHandle, Class<T> stateClass) {
        return this.mdibStorage.getContextStates(descriptorHandle, stateClass);
    }

    @Override
    public List<AbstractContextState> getContextStates(String descriptorHandle) {
        return this.mdibStorage.getContextStates(descriptorHandle);
    }

    @Override
    public List<AbstractContextState> getContextStates() {
        return this.mdibStorage.getContextStates();
    }

    @Override
    public <T extends AbstractContextState> List<T> findContextStatesByType(Class<T> stateClass) {
        return this.mdibStorage.findContextStatesByType(stateClass);
    }

    @Override
    public <T extends AbstractDescriptor> Collection<MdibEntity> findEntitiesByType(Class<T> type) {
        return this.mdibStorage.findEntitiesByType(type);
    }

    @Override
    public <T extends AbstractDescriptor> List<MdibEntity> getChildrenByType(String handle, Class<T> type) {
        return this.mdibStorage.getChildrenByType(handle, type);
    }
}

