/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common.access.helper;

import java.util.Collections;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.access.MdibAccess;
import org.somda.sdc.biceps.common.access.WriteDescriptionResult;
import org.somda.sdc.biceps.common.access.WriteStateResult;
import org.somda.sdc.biceps.common.event.Distributor;
import org.somda.sdc.biceps.common.storage.MdibStoragePreprocessingChain;
import org.somda.sdc.biceps.common.storage.PreprocessingException;

public class WriteUtil {
    private final Logger log;
    private final Distributor eventDistributor;
    private final MdibStoragePreprocessingChain mdibAccessPreprocessing;
    private final ReentrantReadWriteLock readWriteLock;
    private final MdibAccess mdibAccess;

    public WriteUtil(Logger logger, Distributor eventDistributor, MdibStoragePreprocessingChain mdibAccessPreprocessing, ReentrantReadWriteLock readWriteLock, MdibAccess mdibAccess) {
        this.log = logger;
        this.eventDistributor = eventDistributor;
        this.mdibAccessPreprocessing = mdibAccessPreprocessing;
        this.readWriteLock = readWriteLock;
        this.mdibAccess = mdibAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteDescriptionResult writeDescription(Function<MdibDescriptionModifications, WriteDescriptionResult> lockedWriteDescription, MdibDescriptionModifications descriptionModifications) throws PreprocessingException {
        WriteDescriptionResult modificationResult;
        this.acquireWriteLock();
        long startTime = 0L;
        if (this.log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            this.log.debug("Start writing description");
        }
        try {
            this.mdibAccessPreprocessing.processDescriptionModifications(descriptionModifications);
            modificationResult = lockedWriteDescription.apply(descriptionModifications);
            if (descriptionModifications.getModifications().isEmpty()) {
                WriteDescriptionResult writeDescriptionResult = new WriteDescriptionResult(this.mdibAccess.getMdibVersion(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                return writeDescriptionResult;
            }
            this.readWriteLock.readLock().lock();
        }
        catch (PreprocessingException e) {
            this.log.warn("Error while processing description modifications in chain segment {} on handle {}: {}", new Object[]{e.getSegment(), e.getHandle(), e.getMessage()});
            throw e;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        long endTime = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("MDIB version {} written in {} ms", (Object)modificationResult.getMdibVersion(), (Object)(endTime - startTime));
        }
        try {
            this.eventDistributor.sendDescriptionModificationEvent(this.mdibAccess, modificationResult.getInsertedEntities(), modificationResult.getUpdatedEntities(), modificationResult.getDeletedEntities());
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Distributing changes with {} took {} ms", (Object)modificationResult.getMdibVersion(), (Object)(System.currentTimeMillis() - endTime));
        }
        return modificationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteStateResult writeStates(Function<MdibStateModifications, WriteStateResult> lockedWriteStates, MdibStateModifications stateModifications) throws PreprocessingException {
        WriteStateResult modificationResult;
        this.acquireWriteLock();
        long startTime = 0L;
        if (this.log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            this.log.debug("Start writing states");
        }
        try {
            this.mdibAccessPreprocessing.processStateModifications(stateModifications);
            modificationResult = lockedWriteStates.apply(stateModifications);
            if (stateModifications.getStates().isEmpty()) {
                WriteStateResult writeStateResult = new WriteStateResult(this.mdibAccess.getMdibVersion(), Collections.emptyList());
                return writeStateResult;
            }
            this.readWriteLock.readLock().lock();
        }
        catch (PreprocessingException e) {
            this.log.warn("Error while processing state modifications in chain segment {} on handle {}: {}", new Object[]{e.getSegment(), e.getHandle(), e.getMessage()});
            throw e;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        long endTime = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("MDIB version {} written in {} ms", (Object)modificationResult.getMdibVersion(), (Object)(endTime - startTime));
        }
        try {
            this.eventDistributor.sendStateModificationEvent(this.mdibAccess, stateModifications.getChangeType(), modificationResult.getStates());
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Distributing changes {} took {} ms", (Object)modificationResult.getMdibVersion(), (Object)(System.currentTimeMillis() - endTime));
        }
        return modificationResult;
    }

    private void acquireWriteLock() {
        this.log.debug("Trying to acquire write lock");
        if (this.readWriteLock.getReadHoldCount() > 0) {
            throw new IllegalThreadStateException("Tried to invoke write operation with read lock held by the current thread present. Check if a write description or state function has been executed within a read transaction context.");
        }
        if (!this.readWriteLock.isWriteLockedByCurrentThread()) {
            this.readWriteLock.writeLock().lock();
        }
    }
}

