/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common.event;

import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.access.MdibAccess;
import org.somda.sdc.biceps.common.event.DescriptionModificationMessage;

public class Distributor {
    private static final Logger LOG = LoggerFactory.getLogger(Distributor.class);
    private final EventBus eventBus;

    @Inject
    Distributor(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void registerObserver(Object observer) {
        this.eventBus.register(observer);
    }

    public void unregisterObserver(Object observer) {
        this.eventBus.unregister(observer);
    }

    public void sendDescriptionModificationEvent(MdibAccess mdibAccess, List<MdibEntity> insertedEntities, List<MdibEntity> updatedEntities, List<MdibEntity> deletedEntities) {
        this.eventBus.post((Object)new DescriptionModificationMessage(mdibAccess, insertedEntities, updatedEntities, deletedEntities));
    }

    public void sendStateModificationEvent(MdibAccess mdibAccess, MdibStateModifications.Type changeType, List<?> states) {
        Constructor<?> ctor = null;
        for (Constructor<?> constructor : changeType.getEventMessageClass().getConstructors()) {
            if (constructor.getParameterCount() != 2) continue;
            ctor = constructor;
            break;
        }
        if (ctor == null) {
            LOG.error("Expected constructor to create state modification message not found. Distribution failed.");
            return;
        }
        try {
            this.eventBus.post(ctor.newInstance(mdibAccess, states));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.error("Failed to call state event message constructor", (Throwable)e);
        }
    }
}

