/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common.factory;

import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nullable;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.factory.MdibEntityGuiceAssistedFactory;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdibVersion;

public class MdibEntityFactory {
    private final MdibEntityGuiceAssistedFactory factory;

    @Inject
    MdibEntityFactory(MdibEntityGuiceAssistedFactory factory) {
        this.factory = factory;
    }

    public MdibEntity createMdibEntity(@Nullable String parent, List<String> children, AbstractDescriptor descriptor, List<AbstractState> states, MdibVersion mdibVersion) {
        return this.factory.createMdibEntity(parent, children, descriptor, states, mdibVersion);
    }

    public MdibEntity replaceDescriptorAndStates(MdibEntity mdibEntity, AbstractDescriptor descriptor, List<AbstractState> states) {
        return this.factory.createMdibEntity(mdibEntity.getParent().orElse(null), mdibEntity.getChildren(), descriptor, states, mdibEntity.getLastChanged());
    }

    public MdibEntity replaceStates(MdibEntity mdibEntity, List<AbstractState> states) {
        return this.replaceDescriptorAndStates(mdibEntity, mdibEntity.getDescriptor(), states);
    }

    public MdibEntity replaceChildren(MdibEntity mdibEntity, List<String> children) {
        return this.factory.createMdibEntity(mdibEntity.getParent().orElse(null), children, mdibEntity.getDescriptor(), mdibEntity.getStates(), mdibEntity.getLastChanged());
    }
}

