/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common.storage;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.MdibTypeValidator;
import org.somda.sdc.biceps.common.access.WriteDescriptionResult;
import org.somda.sdc.biceps.common.access.WriteStateResult;
import org.somda.sdc.biceps.common.factory.MdibEntityFactory;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.common.storage.helper.MdibStorageUtil;
import org.somda.sdc.biceps.model.participant.AbstractContextDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.ContextAssociation;
import org.somda.sdc.biceps.model.participant.MdibVersion;

public class MdibStorageImpl
implements MdibStorage {
    private static final Logger LOG = LoggerFactory.getLogger(MdibStorageImpl.class);
    private final MdibEntityFactory entityFactory;
    private final MdibStorageUtil util;
    private final MdibTypeValidator typeValidator;
    private MdibVersion mdibVersion;
    private BigInteger mdDescriptionVersion;
    private BigInteger mdStateVersion;
    private Map<String, MdibEntity> entities;
    private ArrayList<String> rootEntities;
    private Map<String, AbstractContextState> contextStates;

    @AssistedInject
    MdibStorageImpl(MdibEntityFactory entityFactory, MdibStorageUtil util, MdibTypeValidator typeValidator) {
        this(MdibVersion.create(), BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), entityFactory, util, typeValidator);
    }

    @AssistedInject
    MdibStorageImpl(@Assisted MdibVersion initialMdibVersion, MdibEntityFactory entityFactory, MdibStorageUtil util, MdibTypeValidator typeValidator) {
        this(initialMdibVersion, BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), entityFactory, util, typeValidator);
    }

    @AssistedInject
    MdibStorageImpl(@Assisted MdibVersion initialMdibVersion, @Assisted(value="mdDescriptionVersion") BigInteger mdDescriptionVersion, @Assisted(value="mdStateVersion") BigInteger mdStateVersion, MdibEntityFactory entityFactory, MdibStorageUtil util, MdibTypeValidator typeValidator) {
        this.mdibVersion = initialMdibVersion;
        this.mdDescriptionVersion = mdDescriptionVersion;
        this.mdStateVersion = mdStateVersion;
        this.entityFactory = entityFactory;
        this.util = util;
        this.typeValidator = typeValidator;
        this.entities = new HashMap<String, MdibEntity>();
        this.rootEntities = new ArrayList();
        this.contextStates = new HashMap<String, AbstractContextState>();
    }

    @Override
    public <T extends AbstractDescriptor> Optional<T> getDescriptor(String handle, Class<T> descrClass) {
        MdibEntity mdibEntity = this.entities.get(handle);
        if (mdibEntity != null) {
            return this.util.exposeInstance(mdibEntity.getDescriptor(), descrClass);
        }
        return Optional.empty();
    }

    @Override
    public Optional<AbstractDescriptor> getDescriptor(String handle) {
        return this.getDescriptor(handle, AbstractDescriptor.class);
    }

    @Override
    public Optional<MdibEntity> getEntity(String handle) {
        return Optional.ofNullable(this.entities.get(handle));
    }

    @Override
    public <T extends AbstractDescriptor> Collection<MdibEntity> findEntitiesByType(Class<T> type) {
        ArrayList<MdibEntity> result = new ArrayList<MdibEntity>();
        for (MdibEntity entity : this.entities.values()) {
            if (!type.isAssignableFrom(entity.getDescriptor().getClass())) continue;
            result.add(entity);
        }
        return result;
    }

    @Override
    public <T extends AbstractDescriptor> List<MdibEntity> getChildrenByType(String handle, Class<T> type) {
        ArrayList<MdibEntity> result = new ArrayList<MdibEntity>();
        Optional<MdibEntity> entity = this.getEntity(handle);
        if (entity.isEmpty()) {
            return result;
        }
        for (String child : entity.get().getChildren()) {
            this.getEntity(child).ifPresent(childEntity -> {
                if (type.isAssignableFrom(childEntity.getDescriptor().getClass())) {
                    result.add((MdibEntity)childEntity);
                }
            });
        }
        return result;
    }

    @Override
    public List<MdibEntity> getRootEntities() {
        return this.util.exposeEntityList(this.entities, this.rootEntities);
    }

    @Override
    public Optional<AbstractState> getState(String handle) {
        return this.getState(handle, AbstractState.class);
    }

    @Override
    public <T extends AbstractState> Optional<T> getState(String handle, Class<T> stateClass) {
        MdibEntity entity = this.entities.get(handle);
        if (entity != null && entity.getStates().size() == 1) {
            return this.util.exposeInstance(entity.getStates().get(0), stateClass);
        }
        AbstractContextState contextState = this.contextStates.get(handle);
        return this.util.exposeInstance(contextState, stateClass);
    }

    @Override
    public <T extends AbstractContextState> List<T> getContextStates(String descriptorHandle, Class<T> stateClass) {
        MdibEntity entity = this.entities.get(descriptorHandle);
        if (entity == null || entity.getStates().isEmpty()) {
            return Collections.emptyList();
        }
        return this.util.exposeListOfType(entity.getStates(), stateClass);
    }

    @Override
    public List<AbstractContextState> getContextStates(String descriptorHandle) {
        MdibEntity entity = this.entities.get(descriptorHandle);
        if (entity == null || entity.getStates().isEmpty()) {
            return Collections.emptyList();
        }
        return this.util.exposeListOfType(entity.getStates(), AbstractContextState.class);
    }

    @Override
    public List<AbstractMultiState> getMultiStates(String descriptorHandle) {
        MdibEntity entity = this.entities.get(descriptorHandle);
        if (entity == null || entity.getStates().isEmpty()) {
            return Collections.emptyList();
        }
        return this.util.exposeListOfType(entity.getStates(), AbstractMultiState.class);
    }

    @Override
    public List<AbstractContextState> getContextStates() {
        return new ArrayList<AbstractContextState>(this.contextStates.values());
    }

    @Override
    public <T extends AbstractContextState> List<T> findContextStatesByType(Class<T> stateClass) {
        ArrayList result = new ArrayList();
        this.contextStates.forEach((handle, state) -> {
            if (stateClass.isAssignableFrom(state.getClass())) {
                result.add((AbstractContextState)stateClass.cast(state));
            }
        });
        return result;
    }

    @Override
    public WriteDescriptionResult apply(MdibVersion mdibVersion, @Nullable BigInteger mdDescriptionVersion, @Nullable BigInteger mdStateVersion, MdibDescriptionModifications descriptionModifications) {
        this.mdibVersion = mdibVersion;
        Optional.ofNullable(mdDescriptionVersion).ifPresent(version -> {
            this.mdDescriptionVersion = version;
        });
        Optional.ofNullable(mdDescriptionVersion).ifPresent(version -> {
            this.mdStateVersion = version;
        });
        ArrayList<MdibEntity> insertedEntities = new ArrayList<MdibEntity>();
        ArrayList<MdibEntity> updatedEntities = new ArrayList<MdibEntity>();
        ArrayList<MdibEntity> deletedEntities = new ArrayList<MdibEntity>();
        ArrayList<String> updatedParentEntitiesDueToInsert = new ArrayList<String>();
        block5: for (MdibDescriptionModification modification : descriptionModifications.getModifications()) {
            List<AbstractState> sanitizedStates = this.removeNotAssociatedContextStates(modification.getStates());
            switch (modification.getModificationType()) {
                case INSERT: {
                    this.insertEntity(modification, sanitizedStates, insertedEntities, updatedParentEntitiesDueToInsert);
                    continue block5;
                }
                case UPDATE: {
                    this.updateEntity(modification, sanitizedStates, updatedEntities);
                    continue block5;
                }
                case DELETE: {
                    this.deleteEntity(modification, deletedEntities);
                    continue block5;
                }
            }
            LOG.warn("Unknown modification type detected. Skip entry while description modification processing.");
        }
        for (String handle : updatedParentEntitiesDueToInsert) {
            if (!updatedEntities.stream().noneMatch(mdibEntity -> handle.equals(mdibEntity.getHandle())) || !insertedEntities.stream().noneMatch(mdibEntity -> handle.equals(mdibEntity.getHandle()))) continue;
            updatedEntities.add(Optional.ofNullable(this.entities.get(handle)).orElseThrow());
        }
        return new WriteDescriptionResult(mdibVersion, insertedEntities, updatedEntities, deletedEntities);
    }

    private List<AbstractState> removeNotAssociatedContextStates(List<AbstractState> states) {
        LinkedList<AbstractState> result = new LinkedList<AbstractState>(states);
        result.removeIf(state -> state instanceof AbstractContextState && ContextAssociation.NO.equals((Object)((AbstractContextState)state).getContextAssociation()));
        return result;
    }

    private void deleteEntity(MdibDescriptionModification modification, List<MdibEntity> deletedEntities) {
        Optional.ofNullable(this.entities.get(modification.getHandle())).ifPresent(mdibEntity -> {
            LOG.debug("[{}] Delete entity: {}", (Object)this.mdibVersion.getInstanceId(), (Object)modification.getDescriptor().getHandle());
            mdibEntity.getParent().ifPresent(parentHandle -> Optional.ofNullable(this.entities.get(parentHandle)).ifPresent(parentEntity -> this.entities.put(parentEntity.getHandle(), this.entityFactory.replaceChildren((MdibEntity)parentEntity, parentEntity.getChildren().stream().filter(s -> s.equals(mdibEntity.getHandle())).collect(Collectors.toList())))));
        });
        MdibEntity deletedEntity = this.entities.get(modification.getHandle());
        if (deletedEntity == null) {
            LOG.warn("Possible inconsistency detected. Entity to delete was not found: {}" + modification.getHandle());
            return;
        }
        this.rootEntities.remove(modification.getHandle());
        this.entities.remove(modification.getHandle());
        this.contextStates.entrySet().removeIf(state -> ((AbstractContextState)state.getValue()).getDescriptorHandle().equals(modification.getHandle()));
        deletedEntities.add(deletedEntity);
    }

    private void updateEntity(MdibDescriptionModification modification, List<AbstractState> sanitizedStates, List<MdibEntity> updatedEntities) {
        Optional.ofNullable(this.entities.get(modification.getHandle())).ifPresent(mdibEntity -> {
            LOG.debug("[{}] Update entity: {}", (Object)this.mdibVersion.getInstanceId(), (Object)modification.getDescriptor());
            this.entities.put(mdibEntity.getHandle(), this.entityFactory.replaceDescriptorAndStates((MdibEntity)mdibEntity, modification.getDescriptor(), sanitizedStates));
            updatedEntities.add(this.entityFactory.replaceDescriptorAndStates((MdibEntity)mdibEntity, modification.getDescriptor(), modification.getStates()));
            this.updateContextStatesMap(modification.getStates());
        });
    }

    private void updateContextStatesMap(List<AbstractState> states) {
        for (AbstractState state : states) {
            Optional<AbstractContextState> contextState = this.typeValidator.toContextState(state);
            if (contextState.isEmpty()) continue;
            if (this.getNotAssociatedContextState(state).isPresent()) {
                this.contextStates.remove(contextState.get().getHandle());
                continue;
            }
            this.contextStates.put(contextState.get().getHandle(), contextState.get());
        }
    }

    private void insertEntity(MdibDescriptionModification modification, List<AbstractState> sanitizedStates, List<MdibEntity> insertedEntities, List<String> updatedEntityHandles) {
        MdibEntity mdibEntityForStorage = this.entityFactory.createMdibEntity(modification.getParentHandle().orElse(null), new ArrayList<String>(), modification.getDescriptor(), sanitizedStates, this.mdibVersion);
        MdibEntity mdibEntityForResultSet = this.entityFactory.createMdibEntity(modification.getParentHandle().orElse(null), new ArrayList<String>(), modification.getDescriptor(), modification.getStates(), this.mdibVersion);
        if (modification.getParentHandle().isPresent()) {
            Optional.ofNullable(this.entities.get(modification.getParentHandle().get())).ifPresent(parentEntity -> {
                ArrayList<String> children = new ArrayList<String>(parentEntity.getChildren());
                children.add(mdibEntityForStorage.getHandle());
                this.entities.put(parentEntity.getHandle(), this.entityFactory.replaceChildren((MdibEntity)parentEntity, Collections.unmodifiableList(children)));
                updatedEntityHandles.add(parentEntity.getHandle());
            });
        } else {
            this.rootEntities.add(mdibEntityForStorage.getHandle());
        }
        this.entities.put(mdibEntityForStorage.getHandle(), mdibEntityForStorage);
        LOG.debug("[{}] Insert entity: {}", (Object)this.mdibVersion.getInstanceId(), (Object)mdibEntityForStorage.getDescriptor());
        if (mdibEntityForStorage.getDescriptor() instanceof AbstractContextDescriptor) {
            this.contextStates.putAll(mdibEntityForStorage.getStates().stream().map(state -> (AbstractContextState)state).collect(Collectors.toMap(AbstractMultiState::getHandle, state -> state)));
        }
        insertedEntities.add(mdibEntityForResultSet);
    }

    @Override
    public WriteStateResult apply(MdibVersion mdibVersion, @Nullable BigInteger mdStateVersion, MdibStateModifications stateModifications) {
        this.mdibVersion = mdibVersion;
        Optional.ofNullable(mdStateVersion).ifPresent(version -> {
            this.mdStateVersion = version;
        });
        MdibDescriptionModifications descriptionModifications = null;
        ArrayList<AbstractState> modifiedStates = new ArrayList<AbstractState>();
        for (AbstractState modification : stateModifications.getStates()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[{}] Update state: {}", (Object)mdibVersion.getSequenceId(), (Object)modification);
            }
            modifiedStates.add(modification);
            MdibEntity mdibEntity = this.entities.get(modification.getDescriptorHandle());
            if (mdibEntity == null) {
                AbstractDescriptor descr;
                Optional<AbstractContextState> contextState = this.getNotAssociatedContextState(modification);
                if (contextState.isPresent()) {
                    LOG.debug("Found update on context state {} with association=not-associated; do not store in MDIB", (Object)contextState.get().getHandle());
                    continue;
                }
                if (descriptionModifications == null) {
                    descriptionModifications = MdibDescriptionModifications.create();
                }
                try {
                    descr = (AbstractDescriptor)this.typeValidator.resolveDescriptorType(modification.getClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOG.warn("Ignore modification. Reason: could not instantiate descriptor type for handle {}.", (Object)modification.getDescriptorHandle());
                    LOG.trace("Ignore modification", (Throwable)e);
                    continue;
                }
                descr.setHandle(modification.getDescriptorHandle());
                descr.setDescriptorVersion(BigInteger.valueOf(-1L));
                descriptionModifications.insert(descr, modification);
                continue;
            }
            mdibEntity.doIfSingleState(state -> this.entities.put(mdibEntity.getHandle(), this.entityFactory.replaceStates(mdibEntity, Collections.singletonList(modification)))).orElse(states -> {
                AbstractMultiState modificationAsMultiState = this.typeValidator.toMultiState(modification).orElseThrow(() -> new RuntimeException(String.format("Found a non-matching multi-state for multi-state entity update (descriptor handle: %s)", mdibEntity.getHandle())));
                ArrayList<AbstractMultiState> newStates = new ArrayList<AbstractMultiState>();
                boolean found = false;
                for (AbstractMultiState multiState : states) {
                    if (multiState.getHandle().equals(modificationAsMultiState.getHandle())) {
                        found = true;
                        if (this.getNotAssociatedContextState((AbstractState)modificationAsMultiState).isPresent()) {
                            LOG.debug("Found context state {} with association=not-associated; refuse storage in MDIB", (Object)modificationAsMultiState.getHandle());
                            this.contextStates.remove(multiState.getHandle());
                            continue;
                        }
                        LOG.debug("Replacing already present multi-state {}", (Object)multiState.getHandle());
                        newStates.add(modificationAsMultiState);
                        continue;
                    }
                    newStates.add(multiState);
                }
                if (!found && this.getNotAssociatedContextState((AbstractState)modificationAsMultiState).isEmpty()) {
                    LOG.debug("Adding new MultiState {}", (Object)modificationAsMultiState.getHandle());
                    newStates.add(modificationAsMultiState);
                }
                this.entities.put(mdibEntity.getHandle(), this.entityFactory.replaceStates(mdibEntity, Collections.unmodifiableList(newStates)));
                newStates.stream().filter(abstractMultiState -> abstractMultiState instanceof AbstractContextState).map(abstractMultiState -> (AbstractContextState)abstractMultiState).collect(Collectors.toList()).forEach(abstractContextState -> this.contextStates.put(abstractContextState.getHandle(), (AbstractContextState)abstractContextState));
            });
        }
        if (descriptionModifications != null) {
            this.apply(mdibVersion, null, null, descriptionModifications);
        }
        return new WriteStateResult(mdibVersion, modifiedStates);
    }

    @Override
    public MdibVersion getMdibVersion() {
        return this.mdibVersion;
    }

    @Override
    public BigInteger getMdDescriptionVersion() {
        return this.mdDescriptionVersion;
    }

    @Override
    public BigInteger getMdStateVersion() {
        return this.mdStateVersion;
    }

    private Optional<AbstractContextState> getNotAssociatedContextState(AbstractState state) {
        AbstractContextState contextState;
        if (state instanceof AbstractContextState && ((contextState = (AbstractContextState)state).getContextAssociation() == null || ContextAssociation.NO.equals((Object)contextState.getContextAssociation()))) {
            return Optional.of(contextState);
        }
        return Optional.empty();
    }
}

