/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common.storage;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Optional;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.MdibTypeValidator;
import org.somda.sdc.biceps.common.storage.DescriptionPreprocessingSegment;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.common.storage.StatePreprocessingSegment;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;

public class MdibStoragePreprocessingChain {
    private final MdibStorage mdibStorage;
    private final List<DescriptionPreprocessingSegment> descriptionChainSegments;
    private final List<StatePreprocessingSegment> stateChainSegments;
    private final MdibTypeValidator typeValidator;

    @Inject
    MdibStoragePreprocessingChain(@Assisted MdibStorage mdibStorage, @Assisted List<DescriptionPreprocessingSegment> descriptionChainSegments, @Assisted List<StatePreprocessingSegment> stateChainSegments, MdibTypeValidator typeValidator) {
        this.mdibStorage = mdibStorage;
        this.descriptionChainSegments = descriptionChainSegments;
        this.stateChainSegments = stateChainSegments;
        this.typeValidator = typeValidator;
    }

    public void processDescriptionModifications(MdibDescriptionModifications modifications) throws PreprocessingException {
        List<MdibDescriptionModification> modificationList = modifications.getModifications();
        int sizeToIterate = modificationList.size();
        this.descriptionChainSegments.forEach(chainSegment -> chainSegment.beforeFirstModification(modifications, this.mdibStorage));
        for (int i = 0; i < sizeToIterate; ++i) {
            for (DescriptionPreprocessingSegment chainSegment2 : this.descriptionChainSegments) {
                try {
                    chainSegment2.process(modifications, modificationList.get(i), this.mdibStorage);
                }
                catch (Exception e) {
                    throw new PreprocessingException(e.getMessage(), e.getCause(), modificationList.get(i).getHandle(), chainSegment2.toString());
                }
            }
            sizeToIterate = modificationList.size();
        }
        this.descriptionChainSegments.forEach(chainSegment -> chainSegment.afterLastModification(modifications, this.mdibStorage));
    }

    public void processStateModifications(MdibStateModifications modifications) throws PreprocessingException {
        this.stateChainSegments.forEach(chainSegment -> chainSegment.beforeFirstModification(modifications, this.mdibStorage));
        for (AbstractState modification : modifications.getStates()) {
            for (StatePreprocessingSegment chainSegment2 : this.stateChainSegments) {
                try {
                    chainSegment2.process(modifications, modification, this.mdibStorage);
                }
                catch (Exception e) {
                    Optional<AbstractMultiState> multiState = this.typeValidator.toMultiState(modification);
                    String handle = modification.getDescriptorHandle();
                    if (multiState.isPresent()) {
                        handle = multiState.get().getHandle();
                    }
                    throw new PreprocessingException(e.getMessage(), e.getCause(), handle, chainSegment2.toString());
                }
            }
        }
        this.stateChainSegments.forEach(chainSegment -> chainSegment.afterLastModification(modifications, this.mdibStorage));
    }
}

