/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.common.storage.helper;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.factory.MdibEntityFactory;
import org.somda.sdc.common.util.ObjectUtil;

public class MdibStorageUtil {
    private final ObjectUtil objectUtil;
    private final MdibEntityFactory entityFactory;

    @Inject
    MdibStorageUtil(ObjectUtil objectUtil, MdibEntityFactory entityFactory) {
        this.objectUtil = objectUtil;
        this.entityFactory = entityFactory;
    }

    public <T> Optional<T> exposeInstance(@Nullable Object instance, Class<T> clazz) {
        if (instance == null) {
            return Optional.empty();
        }
        if (clazz.isAssignableFrom(instance.getClass())) {
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public <T, V> List<T> exposeListOfType(Collection<V> collection, Class<T> clazz) {
        return collection.stream().filter(instance -> instance.getClass().equals(clazz)).map(instance -> instance).collect(Collectors.toList());
    }

    public List<MdibEntity> exposeEntityList(Map<String, MdibEntity> entities, Collection<String> collection) {
        return collection.stream().filter(handle -> entities.get(handle) != null).map(handle -> (MdibEntity)entities.get(handle)).collect(Collectors.toList());
    }
}

