/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.consumer.access;

import com.google.inject.assistedinject.AssistedInject;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.access.ReadTransaction;
import org.somda.sdc.biceps.common.access.WriteDescriptionResult;
import org.somda.sdc.biceps.common.access.WriteStateResult;
import org.somda.sdc.biceps.common.access.factory.ReadTransactionFactory;
import org.somda.sdc.biceps.common.access.helper.WriteUtil;
import org.somda.sdc.biceps.common.event.Distributor;
import org.somda.sdc.biceps.common.preprocessing.DescriptorChildRemover;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.common.storage.MdibStoragePreprocessingChain;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.common.storage.factory.MdibStorageFactory;
import org.somda.sdc.biceps.common.storage.factory.MdibStoragePreprocessingChainFactory;
import org.somda.sdc.biceps.consumer.access.RemoteMdibAccess;
import org.somda.sdc.biceps.consumer.preprocessing.VersionDuplicateHandler;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdibVersion;

public class RemoteMdibAccessImpl
implements RemoteMdibAccess {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteMdibAccessImpl.class);
    private final Distributor eventDistributor;
    private final MdibStorage mdibStorage;
    private final MdibStoragePreprocessingChain localMdibAccessPreprocessing;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReadTransactionFactory readTransactionFactory;
    private final WriteUtil writeUtil;

    @AssistedInject
    RemoteMdibAccessImpl(Distributor eventDistributor, MdibStoragePreprocessingChainFactory chainFactory, MdibStorageFactory mdibStorageFactory, ReentrantReadWriteLock readWriteLock, ReadTransactionFactory readTransactionFactory, VersionDuplicateHandler versionDuplicateHandler, DescriptorChildRemover descriptorChildRemover) {
        this.eventDistributor = eventDistributor;
        this.mdibStorage = mdibStorageFactory.createMdibStorage();
        this.readWriteLock = readWriteLock;
        this.readTransactionFactory = readTransactionFactory;
        this.localMdibAccessPreprocessing = chainFactory.createMdibStoragePreprocessingChain(this.mdibStorage, Arrays.asList(descriptorChildRemover), Arrays.asList(versionDuplicateHandler));
        this.writeUtil = new WriteUtil(LOG, eventDistributor, this.localMdibAccessPreprocessing, readWriteLock, this);
    }

    @Override
    public WriteDescriptionResult writeDescription(MdibVersion mdibVersion, @Nullable BigInteger mdDescriptionVersion, @Nullable BigInteger mdStateVersion, MdibDescriptionModifications mdibDescriptionModifications) throws PreprocessingException {
        return this.writeUtil.writeDescription(descriptionModifications -> this.mdibStorage.apply(mdibVersion, mdDescriptionVersion, mdStateVersion, (MdibDescriptionModifications)descriptionModifications), mdibDescriptionModifications);
    }

    @Override
    public WriteStateResult writeStates(MdibVersion mdibVersion, MdibStateModifications mdibStateModifications) throws PreprocessingException {
        return this.writeUtil.writeStates((MdibStateModifications stateModifications) -> this.mdibStorage.apply(mdibVersion, null, (MdibStateModifications)stateModifications), mdibStateModifications);
    }

    @Override
    public void registerObserver(MdibAccessObserver observer) {
        this.eventDistributor.registerObserver(observer);
    }

    @Override
    public void unregisterObserver(MdibAccessObserver observer) {
        this.eventDistributor.unregisterObserver(observer);
    }

    @Override
    public MdibVersion getMdibVersion() {
        try (ReadTransaction transaction = this.startTransaction();){
            MdibVersion mdibVersion = transaction.getMdibVersion();
            return mdibVersion;
        }
    }

    @Override
    public BigInteger getMdDescriptionVersion() {
        try (ReadTransaction transaction = this.startTransaction();){
            BigInteger bigInteger = transaction.getMdDescriptionVersion();
            return bigInteger;
        }
    }

    @Override
    public BigInteger getMdStateVersion() {
        try (ReadTransaction transaction = this.startTransaction();){
            BigInteger bigInteger = transaction.getMdStateVersion();
            return bigInteger;
        }
    }

    @Override
    public <T extends AbstractDescriptor> Optional<T> getDescriptor(String handle, Class<T> descrClass) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<T> optional = transaction.getDescriptor(handle, descrClass);
            return optional;
        }
    }

    @Override
    public Optional<AbstractDescriptor> getDescriptor(String handle) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<AbstractDescriptor> optional = transaction.getDescriptor(handle, AbstractDescriptor.class);
            return optional;
        }
    }

    @Override
    public Optional<MdibEntity> getEntity(String handle) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<MdibEntity> optional = transaction.getEntity(handle);
            return optional;
        }
    }

    @Override
    public List<MdibEntity> getRootEntities() {
        try (ReadTransaction transaction = this.startTransaction();){
            List<MdibEntity> list = transaction.getRootEntities();
            return list;
        }
    }

    @Override
    public Optional<AbstractState> getState(String handle) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<AbstractState> optional = transaction.getState(handle);
            return optional;
        }
    }

    @Override
    public <T extends AbstractState> Optional<T> getState(String handle, Class<T> stateClass) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<T> optional = transaction.getState(handle, stateClass);
            return optional;
        }
    }

    @Override
    public <T extends AbstractContextState> List<T> getContextStates(String descriptorHandle, Class<T> stateClass) {
        try (ReadTransaction transaction = this.startTransaction();){
            List<T> list = transaction.getContextStates(descriptorHandle, stateClass);
            return list;
        }
    }

    @Override
    public List<AbstractContextState> getContextStates(String descriptorHandle) {
        return null;
    }

    @Override
    public List<AbstractContextState> getContextStates() {
        try (ReadTransaction transaction = this.startTransaction();){
            List<AbstractContextState> list = transaction.getContextStates();
            return list;
        }
    }

    @Override
    public <T extends AbstractContextState> List<T> findContextStatesByType(Class<T> stateClass) {
        try (ReadTransaction transaction = this.startTransaction();){
            List<T> list = transaction.findContextStatesByType(stateClass);
            return list;
        }
    }

    @Override
    public <T extends AbstractDescriptor> Collection<MdibEntity> findEntitiesByType(Class<T> type) {
        try (ReadTransaction transaction = this.startTransaction();){
            Collection<MdibEntity> collection = transaction.findEntitiesByType(type);
            return collection;
        }
    }

    @Override
    public <T extends AbstractDescriptor> List<MdibEntity> getChildrenByType(String handle, Class<T> type) {
        try (ReadTransaction transaction = this.startTransaction();){
            List<MdibEntity> list = transaction.getChildrenByType(handle, type);
            return list;
        }
    }

    @Override
    public ReadTransaction startTransaction() {
        return this.readTransactionFactory.createReadTransaction(this.mdibStorage, this.readWriteLock.readLock());
    }
}

