/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.consumer.preprocessing;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.MdibTypeValidator;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.common.storage.StatePreprocessingSegment;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;

public class VersionDuplicateHandler
implements StatePreprocessingSegment {
    private final MdibTypeValidator typeValidator;
    private List<AbstractState> omittedStates;

    @Inject
    VersionDuplicateHandler(MdibTypeValidator typeValidator) {
        this.typeValidator = typeValidator;
    }

    @Override
    public void beforeFirstModification(MdibStateModifications modifications, MdibStorage mdibStorage) {
        this.omittedStates = null;
    }

    @Override
    public void process(MdibStateModifications modifications, AbstractState modification, MdibStorage storage) {
        Optional<AbstractState> state;
        String handle = modification.getDescriptorHandle();
        Optional<AbstractMultiState> multiState = this.typeValidator.toMultiState(modification);
        if (multiState.isPresent()) {
            handle = multiState.get().getHandle();
        }
        if ((state = storage.getState(handle)).isEmpty()) {
            return;
        }
        if (state.get().getStateVersion().compareTo(modification.getStateVersion()) >= 0) {
            if (this.omittedStates == null) {
                this.omittedStates = new ArrayList<AbstractState>(modifications.getStates().size());
            }
            this.omittedStates.add(modification);
        }
    }

    @Override
    public void afterLastModification(MdibStateModifications modifications, MdibStorage mdibStorage) {
        if (this.omittedStates == null) {
            return;
        }
        modifications.getStates().removeAll(this.omittedStates);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

