/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.model.participant;

import java.math.BigInteger;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.somda.sdc.common.util.ObjectStringifier;
import org.somda.sdc.common.util.UriUtil;

public class MdibVersion {
    private final String sequenceId;
    private final BigInteger instanceId;
    private final BigInteger version;

    public MdibVersion(String sequenceId) {
        this.sequenceId = sequenceId;
        this.version = BigInteger.ZERO;
        this.instanceId = BigInteger.ZERO;
    }

    public MdibVersion(String sequenceId, BigInteger version) {
        this.sequenceId = sequenceId;
        this.version = version;
        this.instanceId = BigInteger.ZERO;
    }

    public MdibVersion(String sequenceId, BigInteger version, BigInteger instanceId) {
        this.sequenceId = sequenceId;
        this.version = version;
        this.instanceId = instanceId;
    }

    public static MdibVersion create() {
        return new MdibVersion(UriUtil.createUuid((UUID)UUID.randomUUID()));
    }

    public static MdibVersion increment(MdibVersion mdibVersion) {
        return new MdibVersion(mdibVersion.getSequenceId(), mdibVersion.getVersion().add(BigInteger.ONE), mdibVersion.getInstanceId());
    }

    public static MdibVersion setVersionCounter(MdibVersion mdibVersion, BigInteger versionCounter) {
        return new MdibVersion(mdibVersion.getSequenceId(), versionCounter, mdibVersion.getInstanceId());
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public BigInteger getInstanceId() {
        return this.instanceId;
    }

    public boolean equals(Object rhsObject) {
        if (rhsObject == this) {
            return true;
        }
        if (!(rhsObject instanceof MdibVersion)) {
            return false;
        }
        MdibVersion rhs = (MdibVersion)rhsObject;
        return URI.create(this.sequenceId).equals(URI.create(rhs.sequenceId)) && this.version.equals(rhs.version) && this.instanceId.equals(rhs.instanceId);
    }

    public int hashCode() {
        return Objects.hash(this.sequenceId, this.instanceId, this.version);
    }

    public Optional<Integer> compareToMdibVersion(@Nullable MdibVersion rhs) {
        if (rhs == null || !URI.create(this.getSequenceId()).equals(URI.create(rhs.getSequenceId()))) {
            return Optional.empty();
        }
        if (this.getInstanceId().compareTo(rhs.getInstanceId()) < 0) {
            return Optional.of(-1);
        }
        if (this.getInstanceId().equals(rhs.getInstanceId())) {
            return Optional.of(this.getVersion().compareTo(rhs.getVersion()));
        }
        if (this.getInstanceId().compareTo(rhs.getInstanceId()) > 0) {
            return Optional.of(1);
        }
        return Optional.empty();
    }

    public String toString() {
        return ObjectStringifier.stringifyAll((Object)this);
    }
}

