/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.provider;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class HandleGenerator {
    private static final AtomicInteger HANDLE_COUNTER = new AtomicInteger(0);
    private final String prefix;

    private HandleGenerator(String prefix) {
        this.prefix = prefix;
    }

    public static HandleGenerator create(String prefix) {
        return new HandleGenerator(prefix);
    }

    public static String createOne(String prefix) {
        return HandleGenerator.concatHandle(prefix, HANDLE_COUNTER.incrementAndGet());
    }

    public static String createGloballyUnique() {
        return UUID.randomUUID().toString();
    }

    public String next() {
        return HandleGenerator.concatHandle(this.prefix, HANDLE_COUNTER.incrementAndGet());
    }

    private static String concatHandle(String prefix, int suffix) {
        return String.format("%s%s", prefix, suffix);
    }
}

