/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.provider.access;

import com.google.inject.assistedinject.AssistedInject;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.access.CopyManager;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.access.ReadTransaction;
import org.somda.sdc.biceps.common.access.WriteDescriptionResult;
import org.somda.sdc.biceps.common.access.WriteStateResult;
import org.somda.sdc.biceps.common.access.factory.ReadTransactionFactory;
import org.somda.sdc.biceps.common.access.helper.WriteUtil;
import org.somda.sdc.biceps.common.event.Distributor;
import org.somda.sdc.biceps.common.preprocessing.DescriptorChildRemover;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.common.storage.MdibStoragePreprocessingChain;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.common.storage.factory.MdibStorageFactory;
import org.somda.sdc.biceps.common.storage.factory.MdibStoragePreprocessingChainFactory;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.biceps.provider.preprocessing.DuplicateChecker;
import org.somda.sdc.biceps.provider.preprocessing.HandleReferenceHandler;
import org.somda.sdc.biceps.provider.preprocessing.TypeConsistencyChecker;
import org.somda.sdc.biceps.provider.preprocessing.VersionHandler;

public class LocalMdibAccessImpl
implements LocalMdibAccess {
    private static final Logger LOG = LoggerFactory.getLogger(LocalMdibAccessImpl.class);
    private final Distributor eventDistributor;
    private final MdibStorage mdibStorage;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReadTransactionFactory readTransactionFactory;
    private final CopyManager copyManager;
    private final WriteUtil writeUtil;
    private MdibVersion mdibVersion = MdibVersion.create();
    private BigInteger mdDescriptionVersion = BigInteger.ZERO;
    private BigInteger mdStateVersion = BigInteger.ZERO;

    @AssistedInject
    LocalMdibAccessImpl(Distributor eventDistributor, MdibStoragePreprocessingChainFactory chainFactory, MdibStorageFactory mdibStorageFactory, ReentrantReadWriteLock readWriteLock, ReadTransactionFactory readTransactionFactory, DuplicateChecker duplicateChecker, VersionHandler versionHandler, TypeConsistencyChecker typeConsistencyChecker, HandleReferenceHandler handleReferenceHandler, DescriptorChildRemover descriptorChildRemover, CopyManager copyManager) {
        this.eventDistributor = eventDistributor;
        this.mdibStorage = mdibStorageFactory.createMdibStorage(this.mdibVersion, BigInteger.ZERO, BigInteger.ZERO);
        this.readWriteLock = readWriteLock;
        this.readTransactionFactory = readTransactionFactory;
        this.copyManager = copyManager;
        MdibStoragePreprocessingChain localMdibAccessPreprocessing = chainFactory.createMdibStoragePreprocessingChain(this.mdibStorage, Arrays.asList(duplicateChecker, typeConsistencyChecker, versionHandler, handleReferenceHandler, descriptorChildRemover), Arrays.asList(versionHandler));
        this.writeUtil = new WriteUtil(LOG, eventDistributor, localMdibAccessPreprocessing, readWriteLock, this);
    }

    @Override
    public WriteDescriptionResult writeDescription(MdibDescriptionModifications mdibDescriptionModifications) throws PreprocessingException {
        MdibDescriptionModifications modificationsCopy = this.copyManager.processInput(mdibDescriptionModifications);
        return this.writeUtil.writeDescription(descriptionModifications -> {
            this.mdibVersion = MdibVersion.increment(this.mdibVersion);
            this.mdDescriptionVersion = this.mdDescriptionVersion.add(BigInteger.ONE);
            this.mdStateVersion = this.mdStateVersion.add(BigInteger.ONE);
            return this.mdibStorage.apply(this.mdibVersion, this.mdDescriptionVersion, this.mdStateVersion, (MdibDescriptionModifications)descriptionModifications);
        }, modificationsCopy);
    }

    @Override
    public WriteStateResult writeStates(MdibStateModifications mdibStateModifications) throws PreprocessingException {
        MdibStateModifications modificationsCopy = this.copyManager.processInput(mdibStateModifications);
        return this.writeUtil.writeStates(stateModifications -> {
            this.mdibVersion = MdibVersion.increment(this.mdibVersion);
            this.mdStateVersion = this.mdStateVersion.add(BigInteger.ONE);
            return this.mdibStorage.apply(this.mdibVersion, this.mdStateVersion, (MdibStateModifications)stateModifications);
        }, modificationsCopy);
    }

    @Override
    public void registerObserver(MdibAccessObserver observer) {
        LOG.info("Register MDIB observer: {}", (Object)observer);
        this.eventDistributor.registerObserver(observer);
    }

    @Override
    public void unregisterObserver(MdibAccessObserver observer) {
        LOG.info("Unreigster MDIB observer: {}", (Object)observer);
        this.eventDistributor.unregisterObserver(observer);
    }

    @Override
    public MdibVersion getMdibVersion() {
        try (ReadTransaction transaction = this.startTransaction();){
            MdibVersion mdibVersion = transaction.getMdibVersion();
            return mdibVersion;
        }
    }

    @Override
    public BigInteger getMdDescriptionVersion() {
        try (ReadTransaction transaction = this.startTransaction();){
            BigInteger bigInteger = transaction.getMdDescriptionVersion();
            return bigInteger;
        }
    }

    @Override
    public BigInteger getMdStateVersion() {
        try (ReadTransaction transaction = this.startTransaction();){
            BigInteger bigInteger = transaction.getMdStateVersion();
            return bigInteger;
        }
    }

    @Override
    public <T extends AbstractDescriptor> Optional<T> getDescriptor(String handle, Class<T> descrClass) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<T> optional = transaction.getDescriptor(handle, descrClass);
            return optional;
        }
    }

    @Override
    public Optional<AbstractDescriptor> getDescriptor(String handle) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<AbstractDescriptor> optional = transaction.getDescriptor(handle, AbstractDescriptor.class);
            return optional;
        }
    }

    @Override
    public Optional<MdibEntity> getEntity(String handle) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<MdibEntity> optional = transaction.getEntity(handle);
            return optional;
        }
    }

    @Override
    public List<MdibEntity> getRootEntities() {
        try (ReadTransaction transaction = this.startTransaction();){
            List<MdibEntity> list = transaction.getRootEntities();
            return list;
        }
    }

    @Override
    public Optional<AbstractState> getState(String handle) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<AbstractState> optional = transaction.getState(handle);
            return optional;
        }
    }

    @Override
    public <T extends AbstractState> Optional<T> getState(String handle, Class<T> stateClass) {
        try (ReadTransaction transaction = this.startTransaction();){
            Optional<T> optional = transaction.getState(handle, stateClass);
            return optional;
        }
    }

    @Override
    public <T extends AbstractContextState> List<T> getContextStates(String descriptorHandle, Class<T> stateClass) {
        try (ReadTransaction transaction = this.startTransaction();){
            List<T> list = transaction.getContextStates(descriptorHandle, stateClass);
            return list;
        }
    }

    @Override
    public List<AbstractContextState> getContextStates(String descriptorHandle) {
        try (ReadTransaction transaction = this.startTransaction();){
            List<AbstractContextState> list = transaction.getContextStates(descriptorHandle);
            return list;
        }
    }

    @Override
    public List<AbstractContextState> getContextStates() {
        try (ReadTransaction transaction = this.startTransaction();){
            List<AbstractContextState> list = transaction.getContextStates();
            return list;
        }
    }

    @Override
    public <T extends AbstractContextState> List<T> findContextStatesByType(Class<T> stateClass) {
        try (ReadTransaction transaction = this.startTransaction();){
            List<T> list = transaction.findContextStatesByType(stateClass);
            return list;
        }
    }

    @Override
    public <T extends AbstractDescriptor> Collection<MdibEntity> findEntitiesByType(Class<T> type) {
        try (ReadTransaction transaction = this.startTransaction();){
            Collection<MdibEntity> collection = transaction.findEntitiesByType(type);
            return collection;
        }
    }

    @Override
    public <T extends AbstractDescriptor> List<MdibEntity> getChildrenByType(String handle, Class<T> type) {
        try (ReadTransaction transaction = this.startTransaction();){
            List<MdibEntity> list = transaction.getChildrenByType(handle, type);
            return list;
        }
    }

    @Override
    public ReadTransaction startTransaction() {
        return this.readTransactionFactory.createReadTransaction(this.mdibStorage, this.readWriteLock.readLock());
    }
}

