/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.provider.preprocessing;

import com.google.inject.Inject;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.MdibTreeValidator;
import org.somda.sdc.biceps.common.storage.DescriptionPreprocessingSegment;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.provider.preprocessing.CardinalityException;

public class CardinalityChecker
implements DescriptionPreprocessingSegment {
    private static final Logger LOG = LoggerFactory.getLogger(CardinalityChecker.class);
    private final MdibTreeValidator treeValidator;

    @Inject
    CardinalityChecker(MdibTreeValidator treeValidator) {
        this.treeValidator = treeValidator;
    }

    @Override
    public void process(MdibDescriptionModifications allModifications, MdibDescriptionModification currentModification, MdibStorage storage) throws CardinalityException {
        Optional<MdibEntity> parentEntityFromStorage;
        if (currentModification.getModificationType() != MdibDescriptionModification.Type.INSERT) {
            return;
        }
        Optional<String> parentHandle = currentModification.getParentHandle();
        if (parentHandle.isEmpty()) {
            return;
        }
        AbstractDescriptor descriptor = currentModification.getDescriptor();
        if (this.isSameTypeInModifications(allModifications, descriptor, parentHandle.get()) && !this.treeValidator.isManyAllowed(descriptor)) {
            this.throwException(descriptor);
        }
        if ((parentEntityFromStorage = storage.getEntity(parentHandle.get())).isEmpty()) {
            LOG.warn("Expected a parent in the MDIB storage, but none found: %s", (Object)parentHandle.get());
            return;
        }
        if (storage.getChildrenByType(parentHandle.get(), descriptor.getClass()).size() > 0 && !this.treeValidator.isManyAllowed(descriptor)) {
            this.throwException(descriptor);
        }
    }

    private boolean isSameTypeInModifications(MdibDescriptionModifications modifications, AbstractDescriptor descriptor, String parentHandle) {
        return modifications.getModifications().stream().filter(mod -> mod.getModificationType() == MdibDescriptionModification.Type.INSERT).filter(mod -> !mod.getDescriptor().getHandle().equals(descriptor.getHandle())).filter(mod -> mod.getParentHandle().isPresent() && mod.getParentHandle().get().equals(parentHandle)).anyMatch(mod -> mod.getDescriptor().getClass().equals(descriptor.getClass()));
    }

    private void throwException(AbstractDescriptor descriptor) throws CardinalityException {
        throw new CardinalityException(String.format("Type %s is not allowed to appear more than once as a child (see handle %s)", descriptor.getClass().getSimpleName(), descriptor.getHandle()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

