/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.provider.preprocessing;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.storage.DescriptionPreprocessingSegment;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.provider.preprocessing.HandleDuplicatedException;

public class DuplicateChecker
implements DescriptionPreprocessingSegment {
    private final Set<String> handleCache = new HashSet<String>();

    @Inject
    DuplicateChecker() {
    }

    @Override
    public void beforeFirstModification(MdibDescriptionModifications modifications, MdibStorage mdibStorage) {
        this.handleCache.clear();
    }

    @Override
    public void process(MdibDescriptionModifications allModifications, MdibDescriptionModification currentModification, MdibStorage storage) throws Exception {
        if (currentModification.getModificationType() == MdibDescriptionModification.Type.INSERT && storage.getEntity(currentModification.getHandle()).isPresent()) {
            throw new HandleDuplicatedException(String.format("Inserted handle is a duplicate: %s", currentModification.getHandle()));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

