/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.provider.preprocessing;

import com.google.common.base.Joiner;
import java.util.Optional;
import javax.inject.Inject;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibTreeValidator;
import org.somda.sdc.biceps.common.storage.DescriptionPreprocessingSegment;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.MdsDescriptor;
import org.somda.sdc.biceps.provider.preprocessing.TypeConsistencyException;

public class TypeConsistencyChecker
implements DescriptionPreprocessingSegment {
    private MdibTreeValidator treeValidator;

    @Inject
    TypeConsistencyChecker(MdibTreeValidator treeValidator) {
        this.treeValidator = treeValidator;
    }

    @Override
    public void process(MdibDescriptionModifications allModifications, MdibDescriptionModification currentModification, MdibStorage storage) throws Exception {
        if (currentModification.getModificationType() != MdibDescriptionModification.Type.INSERT) {
            return;
        }
        AbstractDescriptor descriptor = currentModification.getDescriptor();
        if (currentModification.getParentHandle().isEmpty()) {
            if (descriptor instanceof MdsDescriptor) {
                return;
            }
            throw new TypeConsistencyException(String.format("Inserted entities other than MDS require a parent handle. Handle is %s, type is %s", descriptor.getHandle(), descriptor.getClass()));
        }
        if (descriptor instanceof MdsDescriptor) {
            throw new TypeConsistencyException(String.format("MDS shall not possess a parent handle. Handle is %s", descriptor.getHandle()));
        }
        Optional<AbstractDescriptor> parentFromStorage = storage.getDescriptor(currentModification.getParentHandle().get());
        AbstractDescriptor parentDescriptor = parentFromStorage.isPresent() ? parentFromStorage.get() : allModifications.getModifications().stream().filter(mod -> mod.getModificationType() == MdibDescriptionModification.Type.INSERT).filter(mod -> mod.getDescriptor().getHandle().equals(currentModification.getParentHandle().get())).map(MdibDescriptionModification::getDescriptor).findAny().orElseThrow(() -> new TypeConsistencyException(String.format("No parent descriptor found with handle %s", currentModification.getParentHandle().get())));
        if (!this.treeValidator.isValidParent(parentDescriptor, descriptor)) {
            throw new TypeConsistencyException(String.format("Parent descriptor of %s is invalid: %s. Valid parents: [%s].", descriptor.getClass(), parentDescriptor.getClass(), Joiner.on((String)", ").join(this.treeValidator.allowedParents(descriptor))));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

