/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.provider.preprocessing;

import com.google.inject.Inject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.MdibTypeValidator;
import org.somda.sdc.biceps.common.storage.DescriptionPreprocessingSegment;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.common.storage.StatePreprocessingSegment;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdsDescriptor;
import org.somda.sdc.biceps.provider.preprocessing.VersioningException;
import org.somda.sdc.biceps.provider.preprocessing.helper.VersionPair;
import org.somda.sdc.common.util.ObjectUtil;

public class VersionHandler
implements DescriptionPreprocessingSegment,
StatePreprocessingSegment {
    private final MdibTypeValidator mdibTypeValidator;
    private final ObjectUtil objectUtil;
    private Map<String, VersionPair> versionsWorkingCopy;
    private Map<String, VersionPair> versions;
    private final Set<String> updatedParents;

    @Inject
    VersionHandler(MdibTypeValidator mdibTypeValidator, ObjectUtil objectUtil) {
        this.mdibTypeValidator = mdibTypeValidator;
        this.objectUtil = objectUtil;
        this.versionsWorkingCopy = new HashMap<String, VersionPair>();
        this.versions = new HashMap<String, VersionPair>();
        this.updatedParents = new HashSet<String>();
    }

    @Override
    public void beforeFirstModification(MdibDescriptionModifications modifications, MdibStorage storage) {
        this.updatedParents.clear();
        this.versionsWorkingCopy = (Map)this.objectUtil.deepCopy(this.versions);
    }

    @Override
    public void afterLastModification(MdibDescriptionModifications modifications, MdibStorage storage) {
        this.versions = this.versionsWorkingCopy;
    }

    @Override
    public void beforeFirstModification(MdibStateModifications modifications, MdibStorage storage) {
        this.versionsWorkingCopy = (Map)this.objectUtil.deepCopy(this.versions);
    }

    @Override
    public void afterLastModification(MdibStateModifications modifications, MdibStorage storage) {
        this.versions = this.versionsWorkingCopy;
    }

    @Override
    public void process(MdibDescriptionModifications modifications, MdibDescriptionModification modification, MdibStorage storage) throws VersioningException {
        switch (modification.getModificationType()) {
            case INSERT: {
                this.processInsert(modifications, modification.getDescriptor(), modification.getStates(), modification.getParentHandle(), storage);
                break;
            }
            case UPDATE: {
                this.processUpdate(modification.getDescriptor(), modification.getStates(), storage);
                break;
            }
            case DELETE: {
                this.processDelete(modification.getDescriptor(), storage);
                break;
            }
            default: {
                throw new VersioningException(String.format("Default clause reached in process, modification %s was unknown", new Object[]{modification.getModificationType()}));
            }
        }
    }

    @Override
    public void process(MdibStateModifications modifications, AbstractState state, MdibStorage storage) throws VersioningException {
        Optional<AbstractMultiState> multiState = this.mdibTypeValidator.toMultiState(state);
        if (multiState.isPresent()) {
            VersionPair versionPair2;
            Optional<VersionPair> multiStateVersionPair = this.getVersionPair(multiState.get());
            if (multiStateVersionPair.isPresent()) {
                versionPair2 = multiStateVersionPair.get();
            } else {
                VersionPair versionPairFromDescr = this.getVersionPair(multiState.get().getDescriptorHandle()).orElseThrow(() -> new VersioningException("Multi-state descriptor was missing during multi state update"));
                versionPair2 = new VersionPair(versionPairFromDescr.getDescriptorVersion(), BigInteger.valueOf(-1L));
            }
            multiState.get().setStateVersion(versionPair2.getStateVersion().add(BigInteger.ONE));
            multiState.get().setDescriptorVersion(versionPair2.getDescriptorVersion());
            this.putVersionPair(multiState.get());
        } else {
            this.getVersionPair(state.getDescriptorHandle()).ifPresent(versionPair -> {
                state.setStateVersion(versionPair.getStateVersion().add(BigInteger.ONE));
                state.setDescriptorVersion(versionPair.getDescriptorVersion());
                this.putVersionPair((VersionPair)versionPair, state);
            });
        }
    }

    private void processDelete(AbstractDescriptor descriptor, MdibStorage storage) throws VersioningException {
        if (descriptor instanceof MdsDescriptor) {
            return;
        }
        Optional<MdibEntity> entity = storage.getEntity(descriptor.getHandle());
        if (entity.isEmpty()) {
            throw new VersioningException("Deletion of an entity requires an existing entity in the MDIB storage");
        }
        String parentHandle = entity.get().getParent().orElseThrow(() -> new VersioningException("MDIB storage inconsistency: parent handle is missing"));
        MdibEntity parentEntity = storage.getEntity(parentHandle).orElseThrow(() -> new VersioningException("MDIB storage inconsistency: parent entity is missing"));
        this.processUpdate(parentEntity.getDescriptor(), parentEntity.getStates(), storage);
    }

    private void processUpdate(AbstractDescriptor descriptor, List<? extends AbstractState> states, MdibStorage storage) throws VersioningException {
        if (this.isUpdatedAlready(descriptor)) {
            return;
        }
        List<? extends AbstractState> statesRef = states;
        if (this.mdibTypeValidator.isMultiStateDescriptor(descriptor)) {
            this.processUpdateWithMultiState(descriptor, statesRef, storage);
        } else {
            if (statesRef.isEmpty()) {
                Optional<AbstractState> state = storage.getState(descriptor.getHandle());
                if (state.isEmpty()) {
                    throw new VersioningException("State is missing to complete the update operation");
                }
                statesRef = Collections.singletonList(state.get());
            }
            this.processUpdateWithSingleState(descriptor, statesRef.get(0));
        }
        this.setUpdated(descriptor);
    }

    private void processUpdateWithMultiState(AbstractDescriptor descriptor, List<? extends AbstractState> states, MdibStorage storage) throws VersioningException {
        VersionPair versionPair = this.getVersionPair(descriptor).orElseThrow(() -> new VersioningException("Expected existing version on update, but none found"));
        descriptor.setDescriptorVersion(versionPair.getDescriptorVersion().add(BigInteger.ONE));
        this.putVersionPair(descriptor);
        Map<String, AbstractMultiState> multiStatesFromStorage = storage.getMultiStates(descriptor.getHandle()).stream().collect(Collectors.toMap(o -> o.getHandle(), o -> o));
        Consumer<AbstractMultiState> replaceVersions = multiState -> {
            VersionPair stateVersionPair = this.getVersionPair((AbstractMultiState)multiState).orElse(new VersionPair());
            multiState.setDescriptorVersion(descriptor.getDescriptorVersion());
            multiState.setStateVersion(stateVersionPair.getStateVersion().add(BigInteger.ONE));
            this.putVersionPair((AbstractMultiState)multiState);
        };
        for (AbstractState abstractState : states) {
            AbstractMultiState multiState2 = this.mdibTypeValidator.toMultiState(abstractState).orElseThrow(() -> new VersioningException("Expected multi state, but single state found"));
            replaceVersions.accept(multiState2);
            multiStatesFromStorage.remove(multiState2.getHandle());
        }
        for (Map.Entry entry : multiStatesFromStorage.entrySet()) {
            replaceVersions.accept((AbstractMultiState)entry.getValue());
        }
    }

    private void processUpdateWithSingleState(AbstractDescriptor descriptor, AbstractState state) throws VersioningException {
        VersionPair versionPair = this.getVersionPair(descriptor).orElseThrow(() -> new VersioningException("Expected existing version on update, but none found"));
        descriptor.setDescriptorVersion(versionPair.getDescriptorVersion().add(BigInteger.ONE));
        state.setDescriptorVersion(descriptor.getDescriptorVersion());
        state.setStateVersion(versionPair.getStateVersion().add(BigInteger.ONE));
        this.putVersionPair(descriptor, state);
    }

    private void processInsert(MdibDescriptionModifications modifications, AbstractDescriptor descriptor, List<? extends AbstractState> states, Optional<String> parentHandle, MdibStorage storage) throws VersioningException {
        if (this.mdibTypeValidator.isMultiStateDescriptor(descriptor)) {
            this.processInsertWithMultiState(descriptor, states);
        } else {
            if (states.isEmpty()) {
                throw new VersioningException("State is missing to complete the insert operation");
            }
            this.processInsertWithSingleState(descriptor, states.get(0));
        }
        this.setUpdated(descriptor);
        if (parentHandle.isPresent()) {
            Optional<MdibEntity> entity = storage.getEntity(parentHandle.get());
            if (entity.isEmpty()) {
                if (!this.updatedParents.contains(parentHandle.get())) {
                    throw new VersioningException("Missing parent to be inserted before child");
                }
            } else {
                this.processUpdate(entity.get().getDescriptor(), entity.get().getStates(), storage);
            }
        }
    }

    private void processInsertWithSingleState(AbstractDescriptor descriptor, AbstractState state) {
        VersionPair versionPair = this.getVersionPair(descriptor).orElse(new VersionPair());
        descriptor.setDescriptorVersion(versionPair.getDescriptorVersion().add(BigInteger.ONE));
        state.setDescriptorVersion(descriptor.getDescriptorVersion());
        state.setStateVersion(versionPair.getStateVersion().add(BigInteger.ONE));
        this.putVersionPair(descriptor, state);
    }

    private void processInsertWithMultiState(AbstractDescriptor descriptor, List<? extends AbstractState> states) throws VersioningException {
        VersionPair versionPair = this.getVersionPair(descriptor).orElse(new VersionPair());
        descriptor.setDescriptorVersion(versionPair.getDescriptorVersion().add(BigInteger.ONE));
        this.putVersionPair(descriptor);
        for (AbstractState abstractState : states) {
            AbstractMultiState multiState = this.mdibTypeValidator.toMultiState(abstractState).orElseThrow(() -> new VersioningException("Expected multi-state, but single state found"));
            VersionPair stateVersionPair = this.getVersionPair(multiState).orElse(new VersionPair());
            multiState.setDescriptorVersion(descriptor.getDescriptorVersion());
            multiState.setStateVersion(stateVersionPair.getStateVersion().add(BigInteger.ONE));
            this.putVersionPair(multiState);
        }
    }

    private boolean isUpdatedAlready(AbstractDescriptor descriptor) {
        return this.updatedParents.contains(descriptor.getHandle());
    }

    private void setUpdated(AbstractDescriptor descriptor) {
        this.updatedParents.add(descriptor.getHandle());
    }

    private void putVersionPair(VersionPair versionPair, AbstractState state) {
        this.versionsWorkingCopy.put(state.getDescriptorHandle(), new VersionPair(versionPair.getDescriptorVersion(), state.getStateVersion()));
    }

    private void putVersionPair(AbstractDescriptor descriptor) {
        this.versionsWorkingCopy.put(descriptor.getHandle(), new VersionPair(descriptor.getDescriptorVersion()));
    }

    private void putVersionPair(AbstractDescriptor descriptor, AbstractState state) {
        this.versionsWorkingCopy.put(descriptor.getHandle(), new VersionPair(descriptor.getDescriptorVersion(), state.getStateVersion()));
    }

    private void putVersionPair(AbstractMultiState state) {
        this.versionsWorkingCopy.put(state.getHandle(), new VersionPair(state.getDescriptorVersion(), state.getStateVersion()));
    }

    private Optional<VersionPair> getVersionPair(String handle) {
        return Optional.ofNullable(this.versionsWorkingCopy.get(handle));
    }

    private Optional<VersionPair> getVersionPair(AbstractDescriptor descriptor) {
        return Optional.ofNullable(this.versionsWorkingCopy.get(descriptor.getHandle()));
    }

    private Optional<VersionPair> getVersionPair(AbstractMultiState state) {
        return Optional.ofNullable(this.versionsWorkingCopy.get(state.getHandle()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

