/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.util;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.somda.sdc.common.util.AnyDateTime;

public class AnyDateTimeAdapter
extends XmlAdapter<String, AnyDateTime> {
    private static final DateTimeFormatter LOCAL_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final DateTimeFormatter OFFSET_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    public AnyDateTime unmarshal(String v) {
        try {
            return AnyDateTime.create(OFFSET_FORMATTER.parse((CharSequence)v, OffsetDateTime::from));
        }
        catch (DateTimeParseException e) {
            return AnyDateTime.create(LOCAL_FORMATTER.parse((CharSequence)v, LocalDateTime::from));
        }
    }

    public String marshal(AnyDateTime v) {
        Optional<OffsetDateTime> offset = v.getOffset();
        if (offset.isPresent()) {
            return OFFSET_FORMATTER.format(offset.get());
        }
        return LOCAL_FORMATTER.format(v.getLocal().orElseThrow(() -> new RuntimeException("Could not marshal AnyDateTimeObject as it misses a offset and local part")));
    }
}

